/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.check;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.IsoCategory;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.PatternUtils;
import org.sonar.java.ast.check.JavaAstCheck;
import org.sonar.java.ast.visitor.PublicApiVisitor;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="UndocumentedApi", name="Undocumented API", isoCategory=IsoCategory.Usability, priority=Priority.MAJOR, description="<p>Check that each public class, interface, method and constructor has a Javadoc comment. The following public methods/constructors are not concerned by this rule :</p><ul><li>Getter / Setter</li><li>Method with @Override annotation</li><li>Empty constructor</li></ul>")
public class UndocumentedApiCheck
extends JavaAstCheck {
    @RuleProperty(description="Optional. If this property is not defined, all classes should adhere to this constraint. Ex : **.api.**")
    private String forClasses = new String();
    private WildcardPattern[] patterns;

    @Override
    public List<Integer> getWantedTokens() {
        return PublicApiVisitor.TOKENS;
    }

    @Override
    public void visitToken(DetailAST ast) {
        SourceCode currentResource = this.peekSourceCode();
        SourceClass sourceClass = this.peekParentClass();
        if (WildcardPattern.match((WildcardPattern[])this.getPatterns(), (String)sourceClass.getKey()) && PublicApiVisitor.isPublicApi(ast) && !PublicApiVisitor.isDocumentedApi(ast, this.getFileContents())) {
            SourceFile sourceFile = (SourceFile)currentResource.getParent(SourceFile.class);
            CheckMessage message = new CheckMessage((CodeCheck)this, "Avoid undocumented API", new Object[0]);
            message.setLine(ast.getLineNo());
            sourceFile.log(message);
        }
    }

    private WildcardPattern[] getPatterns() {
        if (this.patterns == null) {
            this.patterns = PatternUtils.createPatterns(StringUtils.defaultIfEmpty((String)this.forClasses, (String)"**"));
        }
        return this.patterns;
    }

    public String getForClasses() {
        return this.forClasses;
    }

    public void setForClasses(String forClasses) {
        this.forClasses = forClasses;
    }
}

