/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.indexer.SquidIndex;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public class PackageVisitor
extends JavaAstVisitor {
    private SquidIndex indexer;

    public PackageVisitor(SquidIndex indexer) {
        this.indexer = indexer;
    }

    public void visitFile(DetailAST ast) {
        if (ast == null) {
            return;
        }
        SourcePackage packageRes = this.createSourcePackage(ast);
        if (this.peekSourceCode().hasChild((SourceCode)packageRes)) {
            packageRes = this.indexer.search(packageRes.getKey());
        }
        packageRes.setMeasure((MetricDef)Metric.PACKAGES, 1);
        this.addSourceCode((SourceCode)packageRes);
    }

    public void leaveFile(DetailAST ast) {
        if (ast == null) {
            return;
        }
        this.popSourceCode();
    }

    private SourcePackage createSourcePackage(DetailAST ast) {
        SourcePackage packageRes;
        if (ast.getType() != 16) {
            packageRes = new SourcePackage("");
        } else {
            String packageName = FullIdent.createFullIdent((DetailAST)ast.getLastChild().getPreviousSibling()).getText();
            packageRes = new SourcePackage(packageName.replace('.', '/'));
        }
        return packageRes;
    }
}

