/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.asm;

import org.objectweb.asm.Label;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmClassProvider;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.squid.api.SourceCodeEdgeUsage;

public class AsmMethodVisitor
extends EmptyVisitor {
    private AsmMethod method;
    private AsmClassProvider asmClassProvider;
    private int lineNumber = 0;
    private boolean emptyMethod = true;

    public AsmMethodVisitor(AsmMethod method, AsmClassProvider asmClassProvider) {
        this.method = method;
        this.asmClassProvider = asmClassProvider;
        this.emptyMethod = true;
    }

    public void visitFieldInsn(int opcode, String owner, String fieldName, String fieldDescription) {
        AsmClass targetClass = this.asmClassProvider.getClass(owner, AsmClassProvider.DETAIL_LEVEL.NOTHING);
        AsmField targetField = targetClass.getFieldOrCreateIt(fieldName);
        this.method.addEdge(new AsmEdge(this.method, targetField, SourceCodeEdgeUsage.CALLS_FIELD, this.lineNumber));
        this.emptyMethod = false;
    }

    public void visitMethodInsn(int opcode, String owner, String methodName, String methodDescription) {
        if (this.isNotCallToJavaArrayMethod(owner)) {
            AsmClass targetClass = this.asmClassProvider.getClass(owner, AsmClassProvider.DETAIL_LEVEL.STRUCTURE);
            AsmMethod targetMethod = targetClass.getMethodOrCreateIt(methodName + methodDescription);
            this.method.addEdge(new AsmEdge(this.method, targetMethod, SourceCodeEdgeUsage.CALLS_METHOD, this.lineNumber));
        }
        this.emptyMethod = false;
    }

    private boolean isNotCallToJavaArrayMethod(String internalName) {
        return internalName.charAt(0) != '[';
    }

    public void visitTryCatchBlock(Label start, Label end, Label handler, String exception) {
        if (exception != null) {
            AsmClass exceptionClass = this.asmClassProvider.getClass(exception, AsmClassProvider.DETAIL_LEVEL.NOTHING);
            this.method.addEdge(new AsmEdge(this.method, exceptionClass, SourceCodeEdgeUsage.USES, this.lineNumber));
        }
        this.emptyMethod = false;
    }

    public void visitTypeInsn(int opcode, String internalName) {
        AsmClass usedClass = this.asmClassProvider.getClass(internalName, AsmClassProvider.DETAIL_LEVEL.NOTHING);
        this.method.addEdge(new AsmEdge(this.method, usedClass, SourceCodeEdgeUsage.USES, this.lineNumber));
        this.emptyMethod = false;
    }

    public void visitLineNumber(int line, Label start) {
        this.lineNumber = line;
    }

    public void visitEnd() {
        this.method.setEmpty(this.emptyMethod);
    }

    public void visitIincInsn(int var, int increment) {
        this.emptyMethod = false;
    }

    public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        this.emptyMethod = false;
    }

    public void visitInsn(int opcode) {
        if (opcode != 177) {
            this.emptyMethod = false;
        }
    }

    public void visitIntInsn(int opcode, int operand) {
        this.emptyMethod = false;
    }

    public void visitJumpInsn(int opcode, Label label) {
        this.emptyMethod = false;
    }

    public void visitLdcInsn(Object cst) {
        if (cst instanceof Type) {
            Type type = (Type)cst;
            AsmClass usedClass = this.asmClassProvider.getClass(type.getInternalName(), AsmClassProvider.DETAIL_LEVEL.NOTHING);
            this.method.addEdge(new AsmEdge(this.method, usedClass, SourceCodeEdgeUsage.USES, this.lineNumber));
        }
        this.emptyMethod = false;
    }

    public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
        this.emptyMethod = false;
    }

    public void visitMultiANewArrayInsn(String desc, int dims) {
        this.emptyMethod = false;
    }

    public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
        this.emptyMethod = false;
    }

    public void visitVarInsn(int opcode, int var) {
        this.emptyMethod = false;
    }
}

