/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.visitor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmField;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.asm.AsmResource;
import org.sonar.java.bytecode.visitor.BytecodeVisitor;
import org.sonar.java.squid.JavaSquidConfiguration;
import org.sonar.squid.api.SourceCodeEdgeUsage;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LCOM4Visitor
extends BytecodeVisitor {
    private AsmClass asmClass;
    private List<Set<AsmResource>> unrelatedBlocks = null;
    private final Set<String> fieldsToExcludeFromLcom4Calculation;

    public LCOM4Visitor(JavaSquidConfiguration conf) {
        this.fieldsToExcludeFromLcom4Calculation = conf.getFielsToExcludeFromLcom4Calculation();
    }

    @Override
    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
        this.unrelatedBlocks = new ArrayList<Set<AsmResource>>();
    }

    @Override
    public void visitMethod(AsmMethod asmMethod) {
        if (this.isMethodElligibleForLCOM4Computation(asmMethod)) {
            Set<AsmResource> block = this.getResourceBlockOrCreateIt(asmMethod);
            for (AsmEdge edge : asmMethod.getOutgoingEdges()) {
                if (!this.isCallToInternalFieldOrMethod(edge) || !this.isNotCallToExcludedFieldFromLcom4Calculation(edge.getTo())) continue;
                AsmResource toResource = edge.getTo();
                this.mergeAsmResourceToBlock(block, toResource);
            }
        }
    }

    private boolean isNotCallToExcludedFieldFromLcom4Calculation(AsmResource to) {
        if (to instanceof AsmField) {
            AsmField field = (AsmField)to;
            return !this.fieldsToExcludeFromLcom4Calculation.contains(field.getName());
        }
        return true;
    }

    private boolean isMethodElligibleForLCOM4Computation(AsmMethod asmMethod) {
        return !asmMethod.isAbstract() && !asmMethod.isStatic() && !asmMethod.isConstructor() && !asmMethod.isEmpty() && !asmMethod.isAccessor() && asmMethod.isBodyLoaded();
    }

    @Override
    public void leaveClass(AsmClass asmClass) {
        int lcom4 = this.unrelatedBlocks.size();
        if (lcom4 == 0) {
            lcom4 = 1;
        }
        this.getSourceClass(asmClass).add((MetricDef)Metric.LCOM4, (double)lcom4);
        this.getSourceClass(asmClass).addData((MetricDef)Metric.LCOM4_BLOCKS, this.unrelatedBlocks);
        if (this.isMainPublicClassInFile(asmClass)) {
            this.getSourceFile(asmClass).add((MetricDef)Metric.LCOM4, (double)lcom4);
            this.getSourceFile(asmClass).addData((MetricDef)Metric.LCOM4_BLOCKS, this.unrelatedBlocks);
        }
    }

    private void mergeAsmResourceToBlock(Set<AsmResource> block, AsmResource toResource) {
        if (block.contains(toResource)) {
            return;
        }
        Set<AsmResource> otherBlock = this.getResourceBlock(toResource);
        if (otherBlock == null) {
            block.add(toResource);
        } else {
            block.addAll(otherBlock);
            this.unrelatedBlocks.remove(otherBlock);
        }
    }

    private boolean isCallToInternalFieldOrMethod(AsmEdge edge) {
        return edge.getTargetAsmClass() == this.asmClass && (edge.getUsage() == SourceCodeEdgeUsage.CALLS_FIELD || edge.getUsage() == SourceCodeEdgeUsage.CALLS_METHOD);
    }

    private Set<AsmResource> getResourceBlockOrCreateIt(AsmResource fromResource) {
        Set<AsmResource> block = this.getResourceBlock(fromResource);
        if (block != null) {
            return block;
        }
        block = new HashSet<AsmResource>();
        block.add(fromResource);
        this.unrelatedBlocks.add(block);
        return block;
    }

    private Set<AsmResource> getResourceBlock(AsmResource fromResource) {
        for (Set<AsmResource> block : this.unrelatedBlocks) {
            if (!block.contains(fromResource)) continue;
            return block;
        }
        return null;
    }
}

