/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.ProjectClasspath;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.AnnotationCheckFactory;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.profiles.RulesProfile;
import org.sonar.api.resources.Project;
import org.sonar.plugins.squid.SquidExecutor;
import org.sonar.plugins.squid.SquidRuleRepository;
import org.sonar.plugins.squid.SquidSearchProxy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Phase(name=Phase.Name.PRE)
@DependedUpon(value={"squid"}, classes={NoSonarFilter.class})
public class SquidSensor
implements Sensor {
    private SquidSearchProxy proxy;
    private NoSonarFilter noSonarFilter;
    private RulesProfile profile;
    private ProjectClasspath projectClasspath;

    public SquidSensor(RulesProfile profile, SquidSearchProxy proxy, NoSonarFilter noSonarFilter, ProjectClasspath projectClasspath) {
        this.proxy = proxy;
        this.noSonarFilter = noSonarFilter;
        this.profile = profile;
        this.projectClasspath = projectClasspath;
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "java".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        boolean analyzePropertyAccessors = project.getConfiguration().getBoolean("sonar.squid.analyse.property.accessors", true);
        String fieldNamesToExcludeFromLcom4Computation = project.getConfiguration().getString("sonar.squid.fieldsToExcludeFromLcom4Computation", "LOG, logger");
        Charset charset = project.getFileSystem().getSourceCharset();
        AnnotationCheckFactory factory = AnnotationCheckFactory.create((RulesProfile)this.profile, (String)"squid", SquidRuleRepository.getCheckClasses());
        SquidExecutor squidExecutor = new SquidExecutor(analyzePropertyAccessors, fieldNamesToExcludeFromLcom4Computation, (CheckFactory)factory, charset);
        squidExecutor.scan(this.getSourceFiles(project), this.getBytecodeFiles(project));
        squidExecutor.save(project, context, this.noSonarFilter);
        squidExecutor.initSonarProxy(this.proxy);
    }

    private List<File> getSourceFiles(Project project) {
        return project.getFileSystem().getJavaSourceFiles();
    }

    private Collection<File> getBytecodeFiles(Project project) {
        File classesDir;
        List bytecodeFiles = this.projectClasspath.getElements();
        if (!this.hasProjectBytecodeFiles(project) && (classesDir = project.getFileSystem().getBuildOutputDir()) != null && classesDir.exists()) {
            bytecodeFiles.remove(classesDir);
        }
        return bytecodeFiles;
    }

    private boolean hasProjectBytecodeFiles(Project project) {
        File classesDir;
        if (!project.getConfiguration().getBoolean("sonar.skipDesign", false) && (classesDir = project.getFileSystem().getBuildOutputDir()) != null && classesDir.exists()) {
            return !FileUtils.listFiles((File)classesDir, (String[])new String[]{"class"}, (boolean)true).isEmpty();
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

