/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.bridges;

import java.util.Map;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.indexer.QueryByMeasure;
import org.sonar.squid.indexer.QueryByParent;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.math.MeasuresDistribution;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public class ChidamberKemererDistributionBridge
extends Bridge {
    public static final int[] LCOM4_LIMITS = new int[]{2, 3, 4, 5, 10};
    public static final int[] RFC_LIMITS = new int[]{0, 5, 10, 20, 30, 50, 90, 150};

    protected ChidamberKemererDistributionBridge() {
        super(true);
    }

    public final void onPackage(SourcePackage squidPackage, Resource sonarPackage) {
        this.context.saveMeasure(sonarPackage, new Measure(CoreMetrics.LCOM4_DISTRIBUTION, this.getDistribution(squidPackage, Metric.LCOM4, LCOM4_LIMITS)));
        this.context.saveMeasure(sonarPackage, new Measure(CoreMetrics.RFC_DISTRIBUTION, this.getDistribution(squidPackage, Metric.RFC, RFC_LIMITS)));
    }

    private String getDistribution(SourcePackage squidPackage, Metric metric, int[] limits) {
        MeasuresDistribution distribution = new MeasuresDistribution(this.squid.search(new Query[]{new QueryByParent((SourceCode)squidPackage), new QueryByType(SourceClass.class), new QueryByMeasure(metric, QueryByMeasure.Operator.GREATER_THAN_EQUALS, 0.0)}));
        Map distrib = distribution.distributeAccordingTo((MetricDef)metric, limits);
        StringBuilder distribString = new StringBuilder(32);
        for (Map.Entry entry : distrib.entrySet()) {
            distribString.append(entry.getKey()).append("=").append(((Integer)entry.getValue()).toString()).append(";");
        }
        distribString.setLength(distribString.length() - 1);
        return distribString.toString();
    }
}

