/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.bridges;

import java.util.Map;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.squid.Squid;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.indexer.QueryByParent;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.math.MeasuresDistribution;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public class ClassComplexityDistributionBridge
extends Bridge {
    public static final int[] CLASSES_DISTRIB_BOTTOM_LIMITS = new int[]{0, 5, 10, 20, 30, 60, 90};

    protected ClassComplexityDistributionBridge() {
        super(false);
    }

    public final void onPackage(SourcePackage squidPackage, Resource sonarPackage) {
        if (squidPackage.getDouble(Metric.METHODS) > 0.0) {
            this.context.saveMeasure(sonarPackage, new Measure(CoreMetrics.CLASS_COMPLEXITY_DISTRIBUTION, this.getClassesComplexityDistribution((SourceCode)squidPackage, this.squid)));
        }
    }

    private String getClassesComplexityDistribution(SourceCode unit, Squid squid) {
        MeasuresDistribution distribution = new MeasuresDistribution(squid.search(new Query[]{new QueryByParent(unit), new QueryByType(SourceClass.class)}));
        Map distrib = distribution.distributeAccordingTo((MetricDef)Metric.COMPLEXITY, CLASSES_DISTRIB_BOTTOM_LIMITS);
        StringBuilder distribString = new StringBuilder(32);
        for (Map.Entry entry : distrib.entrySet()) {
            distribString.append(entry.getKey()).append('=').append(((Integer)entry.getValue()).toString()).append(';');
        }
        distribString.setLength(distribString.length() - 1);
        return distribString.toString();
    }
}

