/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.bridges;

import java.util.Collection;
import java.util.HashMap;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.batch.SquidUtils;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.JavaPackage;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.squid.Squid;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.indexer.QueryByType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ResourceIndex
extends HashMap<SourceCode, Resource> {
    public ResourceIndex loadSquidResources(Squid squid, SensorContext context, Project project) {
        this.loadSquidProject(squid, project);
        this.loadSquidPackages(squid, context);
        this.loadSquidFiles(squid, context);
        return this;
    }

    private void loadSquidProject(Squid squid, Project project) {
        this.put(squid.getProject(), project);
    }

    private void loadSquidPackages(Squid squid, SensorContext context) {
        Collection packages = squid.search(new Query[]{new QueryByType(SourcePackage.class)});
        for (SourceCode squidPackage : packages) {
            JavaPackage sonarPackage = SquidUtils.convertJavaPackageKeyFromSquidFormat((String)squidPackage.getKey());
            context.saveResource((Resource)sonarPackage);
            this.put(squidPackage, context.getResource((Resource)sonarPackage));
        }
    }

    private void loadSquidFiles(Squid squid, SensorContext context) {
        Collection files = squid.search(new Query[]{new QueryByType(SourceFile.class)});
        for (SourceCode squidFile : files) {
            JavaFile sonarFile = SquidUtils.convertJavaFileKeyFromSquidFormat((String)squidFile.getKey());
            context.saveResource((Resource)sonarFile);
            this.put(squidFile, context.getResource((Resource)sonarFile));
        }
    }
}

