/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.check;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.utils.WildcardPattern;
import org.sonar.check.Cardinality;
import org.sonar.check.IsoCategory;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.PatternUtils;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmEdge;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.check.BytecodeCheck;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

@Rule(key="ArchitecturalConstraint", name="Architectural constraint", cardinality=Cardinality.MULTIPLE, isoCategory=IsoCategory.Portability, priority=Priority.MAJOR, description="<p>A source code comply to an architectural model when it fully adheres to a set of architectural constraints. A constraint allows to deny references between classes by pattern.</p><p>You can for instance use this rule to :</p><ul><li>forbid access to **.web.** from **.dao.** classes</li><li>forbid access to java.util.Vector, java.util.Hashtable and java.util.Enumeration from any classes</li><li>forbid access to java.sql.** from **.ui.** and **.web.** classes</li></ul>")
public class ArchitectureCheck
extends BytecodeCheck {
    @RuleProperty(description="Optional. If this property is not defined, all classes should adhere to this constraint. Ex : **.web.**")
    private String fromClasses = new String();
    @RuleProperty(description="Mandatory. Ex : java.util.Vector, java.util.Hashtable, java.util.Enumeration")
    private String toClasses = new String();
    private WildcardPattern[] fromPatterns;
    private WildcardPattern[] toPatterns;
    private AsmClass asmClass;
    private Map<String, CheckMessage> internalNames;

    public String getFromClasses() {
        return this.fromClasses;
    }

    public void setFromClasses(String patterns) {
        this.fromClasses = patterns;
    }

    public String getToClasses() {
        return this.toClasses;
    }

    public void setToClasses(String patterns) {
        this.toClasses = patterns;
    }

    public void visitClass(AsmClass asmClass) {
        String nameAsmClass = asmClass.getInternalName();
        if (WildcardPattern.match((WildcardPattern[])this.getFromPatterns(), (String)nameAsmClass)) {
            this.asmClass = asmClass;
            this.internalNames = Maps.newHashMap();
        } else {
            this.asmClass = null;
        }
    }

    public void leaveClass(AsmClass asmClass) {
        if (this.asmClass != null) {
            for (CheckMessage message : this.internalNames.values()) {
                SourceFile sourceFile = this.getSourceFile(asmClass);
                sourceFile.log(message);
            }
        }
    }

    public void visitEdge(AsmEdge edge) {
        if (this.asmClass != null && edge != null) {
            String internalNameTargetClass = edge.getTargetAsmClass().getInternalName();
            if (!this.internalNames.containsKey(internalNameTargetClass)) {
                if (WildcardPattern.match((WildcardPattern[])this.getToPatterns(), (String)internalNameTargetClass)) {
                    int sourceLineNumber = this.getSourceLineNumber(edge);
                    this.logMessage(this.asmClass.getInternalName(), internalNameTargetClass, sourceLineNumber);
                }
            } else {
                int sourceLineNumber = this.getSourceLineNumber(edge);
                if (this.internalNames.get(internalNameTargetClass).getLine() == 0 && sourceLineNumber != 0) {
                    this.logMessage(this.asmClass.getInternalName(), internalNameTargetClass, sourceLineNumber);
                }
            }
        }
    }

    private int getSourceLineNumber(AsmEdge edge) {
        SourceMethod sourceMethod;
        if (edge.getSourceLineNumber() == 0 && edge.getFrom() instanceof AsmMethod && (sourceMethod = this.getSourceMethod((AsmMethod)edge.getFrom())) != null) {
            return sourceMethod.getStartAtLine();
        }
        return edge.getSourceLineNumber();
    }

    private void logMessage(String fromClass, String toClass, int sourceLineNumber) {
        CheckMessage message = new CheckMessage((CodeCheck)this, fromClass + " must not use " + toClass, new Object[0]);
        message.setLine(sourceLineNumber);
        this.internalNames.put(toClass, message);
    }

    private WildcardPattern[] getFromPatterns() {
        if (this.fromPatterns == null) {
            this.fromPatterns = PatternUtils.createPatterns(StringUtils.defaultIfEmpty((String)this.fromClasses, (String)"**"));
        }
        return this.fromPatterns;
    }

    private WildcardPattern[] getToPatterns() {
        if (this.toPatterns == null) {
            this.toPatterns = PatternUtils.createPatterns(this.toClasses);
        }
        return this.toPatterns;
    }
}

