/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.bridges;

import java.util.Map;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.resources.Resource;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.indexer.QueryByMeasure;
import org.sonar.squid.indexer.QueryByParent;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.math.MeasuresDistribution;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public class FunctionComplexityDistributionBridge
extends Bridge {
    public static final int[] LIMITS = new int[]{1, 2, 4, 6, 8, 10, 12};

    protected FunctionComplexityDistributionBridge() {
        super(false);
    }

    public final void onPackage(SourcePackage squidPackage, Resource sonarPackage) {
        if (squidPackage.getDouble(Metric.METHODS) > 0.0) {
            this.context.saveMeasure(sonarPackage, new Measure(CoreMetrics.FUNCTION_COMPLEXITY_DISTRIBUTION, this.getFunctionComplexityDistribution((SourceCode)squidPackage)));
        }
    }

    private String getFunctionComplexityDistribution(SourceCode unit) {
        MeasuresDistribution distribution = new MeasuresDistribution(this.squid.search(new Query[]{new QueryByParent(unit), new QueryByType(SourceMethod.class), new QueryByMeasure(Metric.ACCESSORS, QueryByMeasure.Operator.EQUALS, 0.0)}));
        Map distrib = distribution.distributeAccordingTo((MetricDef)Metric.COMPLEXITY, LIMITS);
        StringBuilder distribString = new StringBuilder(32);
        for (Map.Entry entry : distrib.entrySet()) {
            distribString.append(entry.getKey()).append("=").append(((Integer)entry.getValue()).toString()).append(";");
        }
        distribString.setLength(distribString.length() - 1);
        return distribString.toString();
    }
}

