/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.checks.CheckFactory;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.TimeProfiler;
import org.sonar.java.ast.JavaAstScanner;
import org.sonar.java.bytecode.BytecodeScanner;
import org.sonar.java.squid.JavaSquidConfiguration;
import org.sonar.java.squid.SquidScanner;
import org.sonar.plugins.squid.SquidSearchProxy;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.plugins.squid.bridges.BridgeFactory;
import org.sonar.plugins.squid.bridges.ResourceIndex;
import org.sonar.squid.Squid;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.api.SquidConfiguration;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SquidExecutor {
    private Squid squid;
    private boolean sourceScanned = false;
    private boolean bytecodeScanned = false;
    private CheckFactory checkFactory;

    public SquidExecutor(boolean analyzePropertyAccessors, String fieldNamesToExcludeFromLcom4Computation, CheckFactory checkFactory, Charset sourcesCharset) {
        JavaSquidConfiguration conf = this.createJavaSquidConfiguration(analyzePropertyAccessors, fieldNamesToExcludeFromLcom4Computation, sourcesCharset);
        this.squid = new Squid((SquidConfiguration)conf);
        this.checkFactory = checkFactory;
    }

    private JavaSquidConfiguration createJavaSquidConfiguration(boolean analyzePropertyAccessors, String fieldNamesToExcludeFromLcom4Computation, Charset sourcesCharset) {
        JavaSquidConfiguration conf = new JavaSquidConfiguration(analyzePropertyAccessors, sourcesCharset);
        if (!StringUtils.isBlank((String)fieldNamesToExcludeFromLcom4Computation)) {
            for (String fieldName : fieldNamesToExcludeFromLcom4Computation.split(",")) {
                if (StringUtils.isBlank((String)fieldName)) continue;
                conf.addFieldToExcludeFromLcom4Calculation(fieldName);
            }
        }
        return conf;
    }

    protected SquidExecutor(Squid squid) {
        this.squid = squid;
    }

    public void scan(Collection<File> sourceFiles, Collection<File> bytecodeFilesOrDirectories) {
        for (Object checker : this.checkFactory.getChecks()) {
            this.squid.registerVisitor((CodeVisitor)checker);
        }
        this.scanSources(sourceFiles);
        if (this.sourceScanned) {
            this.scanBytecode(bytecodeFilesOrDirectories);
        }
        this.squid.decorateSourceCodeTreeWith((MetricDef[])Metric.values());
        this.scanSquidIndex();
    }

    public void save(Project project, SensorContext context, NoSonarFilter noSonarFilter) {
        if (this.sourceScanned) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Squid extraction");
            ResourceIndex resourceIndex = new ResourceIndex().loadSquidResources(this.squid, context, project);
            List<Bridge> bridges = BridgeFactory.create(this.bytecodeScanned, context, this.checkFactory, resourceIndex, this.squid, noSonarFilter);
            this.saveProject(resourceIndex, bridges);
            this.savePackages(resourceIndex, bridges);
            this.saveFiles(resourceIndex, bridges);
            profiler.stop();
        }
    }

    private void saveProject(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Resource sonarResource = (Resource)resourceIndex.get(this.squid.getProject());
        for (Bridge bridge : bridges) {
            bridge.onProject(this.squid.getProject(), (Project)sonarResource);
        }
    }

    private void savePackages(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection packages = this.squid.search(new Query[]{new QueryByType(SourcePackage.class)});
        for (SourceCode squidPackage : packages) {
            Resource sonarPackage = (Resource)resourceIndex.get(squidPackage);
            for (Bridge bridge : bridges) {
                bridge.onPackage((SourcePackage)squidPackage, sonarPackage);
            }
        }
    }

    private void saveFiles(ResourceIndex resourceIndex, List<Bridge> bridges) {
        Collection squidFiles = this.squid.search(new Query[]{new QueryByType(SourceFile.class)});
        for (SourceCode squidFile : squidFiles) {
            Resource sonarFile = (Resource)resourceIndex.get(squidFile);
            for (Bridge bridge : bridges) {
                bridge.onFile((SourceFile)squidFile, sonarFile);
            }
        }
    }

    void scanSources(Collection<File> sourceFiles) {
        if (sourceFiles != null && !sourceFiles.isEmpty()) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java AST scan");
            JavaAstScanner sourceScanner = (JavaAstScanner)this.squid.register(JavaAstScanner.class);
            sourceScanner.scanFiles(sourceFiles);
            this.sourceScanned = true;
            profiler.stop();
        } else {
            this.sourceScanned = false;
        }
    }

    void scanBytecode(Collection<File> bytecodeFilesOrDirectories) {
        if (bytecodeFilesOrDirectories != null && !bytecodeFilesOrDirectories.isEmpty()) {
            TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java bytecode scan");
            BytecodeScanner bytecodeScanner = (BytecodeScanner)this.squid.register(BytecodeScanner.class);
            bytecodeScanner.scan(bytecodeFilesOrDirectories);
            this.bytecodeScanned = true;
            profiler.stop();
        } else {
            this.bytecodeScanned = false;
        }
    }

    void scanSquidIndex() {
        TimeProfiler profiler = new TimeProfiler(this.getClass()).start("Java Squid scan");
        SquidScanner squidScanner = (SquidScanner)this.squid.register(SquidScanner.class);
        squidScanner.scan();
        profiler.stop();
    }

    boolean isSourceScanned() {
        return this.sourceScanned;
    }

    boolean isBytecodeScanned() {
        return this.bytecodeScanned;
    }

    public void initSonarProxy(SquidSearchProxy proxy) {
        this.squid.flush();
        proxy.setTarget(this.squid);
    }

    public Squid getSquid() {
        return this.squid;
    }
}

