/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.batch.Phase;
import org.sonar.api.batch.Sensor;
import org.sonar.api.batch.SensorContext;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.JavaFile;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.ProjectFileSystem;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.SonarException;
import org.sonar.plugins.squid.SquidSensor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Phase(name=Phase.Name.PRE)
@DependsUpon(classes={SquidSensor.class})
@DependedUpon(value={"squid"})
public final class JavaSourceImporter
implements Sensor {
    public boolean shouldExecuteOnProject(Project project) {
        return this.isEnabled(project) && "java".equals(project.getLanguageKey());
    }

    public void analyse(Project project, SensorContext context) {
        this.analyse(project.getFileSystem(), context);
    }

    void analyse(ProjectFileSystem fileSystem, SensorContext context) {
        this.parseDirs(context, fileSystem.mainFiles(new String[]{"java"}), false, fileSystem.getSourceCharset());
        this.parseDirs(context, fileSystem.testFiles(new String[]{"java"}), true, fileSystem.getSourceCharset());
    }

    void parseDirs(SensorContext context, List<InputFile> inputFiles, boolean unitTest, Charset sourcesEncoding) {
        for (InputFile inputFile : inputFiles) {
            JavaFile javaFile = JavaFile.fromRelativePath((String)inputFile.getRelativePath(), (boolean)unitTest);
            this.importSource(context, javaFile, inputFile, sourcesEncoding);
        }
    }

    void importSource(SensorContext context, JavaFile javaFile, InputFile inputFile, Charset sourcesEncoding) {
        try {
            String source = FileUtils.readFileToString((File)inputFile.getFile(), (String)sourcesEncoding.name());
            context.saveSource((Resource)javaFile, source);
        }
        catch (IOException e) {
            throw new SonarException("Unable to read and import the source file : '" + inputFile.getFile().getAbsolutePath() + "' with the charset : '" + sourcesEncoding.name() + "'.", (Throwable)e);
        }
    }

    boolean isEnabled(Project project) {
        return project.getConfiguration().getBoolean("sonar.importSources", true);
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

