/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.bridges;

import java.util.HashSet;
import java.util.Set;
import org.sonar.api.checks.NoSonarFilter;
import org.sonar.api.resources.Resource;
import org.sonar.java.squid.SquidVisitorNotifier;
import org.sonar.java.squid.visitor.SquidVisitor;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

public class NoSonarFilterLoader
extends Bridge {
    private NoSonarFilter noSonarFilter;

    protected NoSonarFilterLoader(NoSonarFilter noSonarFilter) {
        super(false);
        this.noSonarFilter = noSonarFilter;
    }

    public void onFile(SourceFile squidFile, Resource sonarFile) {
        if (this.noSonarFilter != null) {
            HashSet<Integer> ignoredLines = new HashSet<Integer>(squidFile.getNoSonarTagLines());
            new SquidVisitorNotifier(squidFile, new SuppressWarningsVisitor(ignoredLines)).notifyVisitors();
            this.noSonarFilter.addResource(sonarFile, ignoredLines);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SuppressWarningsVisitor
    implements SquidVisitor {
        private Set<Integer> ignoredLines;

        public SuppressWarningsVisitor(Set<Integer> ignoredLines) {
            this.ignoredLines = ignoredLines;
        }

        @Override
        public void visitFile(SourceFile sourceFile) {
        }

        @Override
        public void visitClass(SourceClass sourceClass) {
            if (sourceClass.isSuppressWarnings()) {
                this.visitLines((SourceCode)sourceClass);
            }
        }

        @Override
        public void visitMethod(SourceMethod sourceMethod) {
            if (sourceMethod.isSuppressWarnings()) {
                this.visitLines((SourceCode)sourceMethod);
            }
        }

        private void visitLines(SourceCode sourceCode) {
            for (int line = sourceCode.getStartAtLine(); line <= sourceCode.getEndAtLine(); ++line) {
                this.ignoredLines.add(line);
            }
        }
    }
}

