/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.squid;

import java.nio.charset.Charset;
import java.util.HashSet;
import java.util.Set;
import org.sonar.squid.api.SquidConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavaSquidConfiguration
extends SquidConfiguration {
    private boolean analysePropertyAccessors = true;
    private Set<String> fieldsToExcludeFromLcom4Calculation = new HashSet<String>();
    private static final double COMMENTED_CODE_DEFAULT_THRESHOLD = 0.9;
    private double commentedCodeThreshold = 0.9;

    public JavaSquidConfiguration() {
    }

    public JavaSquidConfiguration(boolean analysePropertyAccessors) {
        this.analysePropertyAccessors = analysePropertyAccessors;
    }

    public JavaSquidConfiguration(double commentedCodeThreshold) {
        this.setCommentedCodeThreshold(commentedCodeThreshold);
    }

    public JavaSquidConfiguration(boolean analysePropertyAccessors, Charset charset) {
        super(charset);
        this.analysePropertyAccessors = analysePropertyAccessors;
    }

    public JavaSquidConfiguration(boolean analysePropertyAccessors, Charset charset, double commentedCodeThreshold) {
        super(charset);
        this.analysePropertyAccessors = analysePropertyAccessors;
        this.setCommentedCodeThreshold(commentedCodeThreshold);
    }

    public boolean isAnalysePropertyAccessors() {
        return this.analysePropertyAccessors;
    }

    public Set<String> getFielsToExcludeFromLcom4Calculation() {
        return this.fieldsToExcludeFromLcom4Calculation;
    }

    public void addFieldToExcludeFromLcom4Calculation(String fieldName) {
        this.fieldsToExcludeFromLcom4Calculation.add(fieldName);
    }

    private void setCommentedCodeThreshold(double commentedCodeThreshold) {
        if (commentedCodeThreshold < 0.0 || commentedCodeThreshold > 1.0) {
            throw new IllegalArgumentException("Commented Code Threshold should be between [0...1]. Current value : " + commentedCodeThreshold);
        }
        this.commentedCodeThreshold = commentedCodeThreshold;
    }

    public double getCommentedCodeThreshold() {
        return this.commentedCodeThreshold;
    }
}

