/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.squid.check;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.squid.check.SquidCheck;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.Metric;

@Rule(key="ClassCyclomaticComplexity", name="Avoid too complex class", priority=Priority.MAJOR, description="<p>The Cyclomatic Complexity is measured by the number of (&&, ||) operators and (if, while, do, for, ?:, catch, switch, case, return, throw) statements in the body of a class plus one for each constructor, method (but not getter/setter), static initializer, or instance initializer in the class. The last return stament in method, if exists, is not taken into account.</p><p>Even when the Cyclomatic Complexity of a class is very high, this complexity might be well distributed among all methods. Nevertheless, most of the time, a very complex class is a class which breaks the <a href='http://en.wikipedia.org/wiki/Single_responsibility_principle'>Single Responsibility Principle</a> and which should be re-factored to be split in several classes.</p>")
public class ClassComplexityCheck
extends SquidCheck {
    @RuleProperty(description="Maximum complexity allowed.", defaultValue="200")
    private Integer max;

    public void visitClass(SourceClass sourceClass) {
        int complexity = sourceClass.getInt(Metric.COMPLEXITY);
        if (complexity > this.max) {
            CheckMessage message = new CheckMessage((CodeCheck)this, "The Cyclomatic Complexity of this class is " + complexity + " which is greater than " + this.max + " authorized.", new Object[0]);
            message.setLine(sourceClass.getStartAtLine());
            message.setCost((double)(complexity - this.max));
            ((SourceFile)sourceClass.getParent(SourceFile.class)).log(message);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

