/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.bridges;

import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Metric;
import org.sonar.api.resources.Resource;
import org.sonar.api.utils.ParsingUtils;
import org.sonar.java.api.JavaClass;
import org.sonar.java.api.JavaMethod;
import org.sonar.plugins.squid.bridges.Bridge;
import org.sonar.squid.api.SourceClass;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

public final class CopyBasicMeasuresBridge
extends Bridge {
    protected CopyBasicMeasuresBridge() {
        super(false);
    }

    public void onFile(SourceFile squidFile, Resource sonarResource) {
        this.copyStandard((SourceCode)squidFile, sonarResource);
        this.copy((SourceCode)squidFile, sonarResource, org.sonar.squid.measures.Metric.FILES, CoreMetrics.FILES);
        this.context.saveMeasure(sonarResource, CoreMetrics.PUBLIC_DOCUMENTED_API_DENSITY, Double.valueOf(ParsingUtils.scaleValue((double)(squidFile.getDouble(org.sonar.squid.measures.Metric.PUBLIC_DOCUMENTED_API_DENSITY) * 100.0), (int)2)));
    }

    public void onClass(SourceClass squidClass, JavaClass sonarClass) {
        this.copyStandard((SourceCode)squidClass, (Resource)sonarClass);
    }

    public void onMethod(SourceMethod squidMethod, JavaMethod sonarMethod) {
        this.copyStandard((SourceCode)squidMethod, (Resource)sonarMethod);
    }

    private void copyStandard(SourceCode squidCode, Resource sonarResource) {
        this.copy(squidCode, sonarResource, org.sonar.squid.measures.Metric.LINES_OF_CODE, CoreMetrics.NCLOC);
        this.copy(squidCode, sonarResource, org.sonar.squid.measures.Metric.LINES, CoreMetrics.LINES);
        this.copy(squidCode, sonarResource, org.sonar.squid.measures.Metric.COMMENT_LINES_WITHOUT_HEADER, CoreMetrics.COMMENT_LINES);
        this.copy(squidCode, sonarResource, org.sonar.squid.measures.Metric.PUBLIC_API, CoreMetrics.PUBLIC_API);
        this.copy(squidCode, sonarResource, org.sonar.squid.measures.Metric.COMPLEXITY, CoreMetrics.COMPLEXITY);
        this.copy(squidCode, sonarResource, org.sonar.squid.measures.Metric.STATEMENTS, CoreMetrics.STATEMENTS);
        this.copy(squidCode, sonarResource, org.sonar.squid.measures.Metric.COMMENTED_OUT_CODE_LINES, CoreMetrics.COMMENTED_OUT_CODE_LINES);
    }

    private void copy(SourceCode squidResource, Resource sonarResource, org.sonar.squid.measures.Metric squidMetric, Metric sonarMetric) {
        this.context.saveMeasure(sonarResource, sonarMetric, Double.valueOf(squidResource.getDouble(squidMetric)));
    }
}

