/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.bytecode.check;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.bytecode.asm.AsmClass;
import org.sonar.java.bytecode.asm.AsmMethod;
import org.sonar.java.bytecode.check.BytecodeCheck;
import org.sonar.java.bytecode.check.SerializableContract;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.CodeCheck;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;

@Rule(key="UnusedProtectedMethod", name="Unused protected method", priority=Priority.MAJOR, description="<p>Protected methods that are never used by any classes in the same project are strongly suspected to be dead code. Dead code means unnecessary, inoperative code that should be removed. This helps in maintenance by decreasing the maintained code size, making it easier to understand the program and preventing bugs from being introduced.</p><p>In the following case, unused protected methods are not considered as dead code by Sonar :</p><ul><li>Protected methods which override a method from a parent class.</li></ul><ul><li>Protected methods of an abstract class.</li></ul>")
public class UnusedProtectedMethodCheck
extends BytecodeCheck {
    private AsmClass asmClass;

    public void visitClass(AsmClass asmClass) {
        this.asmClass = asmClass;
    }

    public void visitMethod(AsmMethod asmMethod) {
        if (!(asmMethod.isUsed() || !asmMethod.isProtected() || this.asmClass.isAbstract() || SerializableContract.methodMatch(asmMethod) || asmMethod.isInherited())) {
            CheckMessage message = new CheckMessage((CodeCheck)this, "Protected method '" + asmMethod.getName() + "(...)' is never used.", new Object[0]);
            SourceMethod sourceMethod = this.getSourceMethod(asmMethod);
            if (sourceMethod != null) {
                message.setLine(sourceMethod.getStartAtLine());
            }
            SourceFile file = this.getSourceFile(this.asmClass);
            file.log(message);
        }
    }
}

