/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.squid;

import java.util.Collection;
import java.util.Collections;
import org.sonar.java.squid.SquidVisitorNotifier;
import org.sonar.java.squid.check.SquidCheck;
import org.sonar.java.squid.visitor.SquidVisitor;
import org.sonar.squid.api.CodeScanner;
import org.sonar.squid.api.CodeVisitor;
import org.sonar.squid.api.Query;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.indexer.QueryByType;
import org.sonar.squid.indexer.SquidIndex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SquidScanner
extends CodeScanner<CodeVisitor> {
    private SquidIndex indexer;

    public SquidScanner(SquidIndex indexer) {
        this.indexer = indexer;
    }

    public void scan() {
        Collection files = this.indexer.search(new Query[]{new QueryByType(SourceFile.class)});
        this.notifySquidVisitors(files);
    }

    private void notifySquidVisitors(Collection<SourceCode> files) {
        SquidVisitor[] visitorArray = this.getVisitors().toArray(new SquidVisitor[this.getVisitors().size()]);
        for (SourceCode sourceFile : files) {
            new SquidVisitorNotifier((SourceFile)sourceFile, visitorArray).notifyVisitors();
        }
    }

    public Collection<Class<? extends CodeVisitor>> getVisitorClasses() {
        return Collections.emptyList();
    }

    public void accept(CodeVisitor visitor) {
        if (visitor instanceof SquidCheck) {
            super.accept(visitor);
        }
    }
}

