/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast;

import com.google.common.collect.Maps;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import org.sonar.api.resources.InputFile;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.java.recognizer.JavaFootprint;
import org.sonar.java.squid.JavaSquidConfiguration;
import org.sonar.squid.recognizer.CodeRecognizer;
import org.sonar.squid.recognizer.LanguageFootprint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class CheckstyleSquidBridgeContext {
    private int[] allTokens;
    private JavaAstVisitor[] visitors;
    private CodeRecognizer codeRecognizer;
    private Map<File, InputFile> inputFilesByPath = Maps.newHashMap();

    CheckstyleSquidBridgeContext() {
    }

    public CheckstyleSquidBridgeContext setASTVisitors(List<JavaAstVisitor> visitors) {
        this.visitors = visitors.toArray(new JavaAstVisitor[visitors.size()]);
        TreeSet<Integer> sorter = new TreeSet<Integer>();
        for (JavaAstVisitor visitor : visitors) {
            sorter.addAll(visitor.getWantedTokens());
            this.allTokens = new int[sorter.size()];
            int i = 0;
            for (Integer itSorted : sorter) {
                this.allTokens[i++] = itSorted;
            }
        }
        return this;
    }

    public CheckstyleSquidBridgeContext setSquidConfiguration(JavaSquidConfiguration conf) {
        this.codeRecognizer = new CodeRecognizer(conf.getCommentedCodeThreshold(), (LanguageFootprint)new JavaFootprint());
        return this;
    }

    public CheckstyleSquidBridgeContext setInputFiles(Collection<InputFile> inputFiles) {
        this.inputFilesByPath.clear();
        for (InputFile inputFile : inputFiles) {
            this.inputFilesByPath.put(inputFile.getFile().getAbsoluteFile(), inputFile);
        }
        return this;
    }

    public int[] getAllTokens() {
        return this.allTokens;
    }

    public InputFile getInputFile(File path) {
        return this.inputFilesByPath.get(path);
    }

    public CodeRecognizer getCodeRecognizer() {
        return this.codeRecognizer;
    }

    public JavaAstVisitor[] getVisitors() {
        return this.visitors;
    }
}

