/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FullIdent;
import org.apache.commons.lang.StringUtils;
import org.sonar.api.resources.InputFile;
import org.sonar.api.resources.InputFileUtils;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.squid.api.AnalysisException;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.api.SourcePackage;
import org.sonar.squid.indexer.SquidIndex;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

public class PackageVisitor
extends JavaAstVisitor {
    private static final String ROOT_PACKAGE = "";
    private SquidIndex indexer;

    public PackageVisitor(SquidIndex indexer) {
        this.indexer = indexer;
    }

    public void visitFile(DetailAST ast) {
        SourcePackage packageRes = ast == null ? this.guessPackage() : this.createSourcePackage(ast);
        if (this.peekSourceCode().hasChild((SourceCode)packageRes)) {
            packageRes = this.indexer.search(packageRes.getKey());
        }
        packageRes.setMeasure((MetricDef)Metric.PACKAGES, 1);
        this.addSourceCode((SourceCode)packageRes);
    }

    private SourcePackage guessPackage() {
        String directory = InputFileUtils.getRelativeDirectory((InputFile)this.getInputFile());
        return new SourcePackage(directory);
    }

    public void leaveFile(DetailAST ast) {
        this.popSourceCode();
    }

    private SourcePackage createSourcePackage(DetailAST ast) {
        String key = ROOT_PACKAGE;
        if (ast.getType() == 16) {
            String packageName = FullIdent.createFullIdent((DetailAST)ast.getLastChild().getPreviousSibling()).getText();
            key = packageName.replace('.', '/');
        }
        this.checkPhysicalDirectory(key);
        return new SourcePackage(key);
    }

    private void checkPhysicalDirectory(String key) {
        String relativeDirectory = InputFileUtils.getRelativeDirectory((InputFile)this.getInputFile());
        if (!StringUtils.equals((String)relativeDirectory, (String)key)) {
            String packageName = StringUtils.replace((String)key, (String)"/", (String)".");
            if (StringUtils.contains((String)relativeDirectory, (String)key) || StringUtils.contains((String)key, (String)relativeDirectory)) {
                throw new AnalysisException(String.format("The source directory does not correspond to the package declaration %s", packageName));
            }
            throw new AnalysisException(String.format("The package declaration %s does not correspond to the file path %s", packageName, this.getInputFile().getRelativePath()));
        }
    }
}

