/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.AnnotationUtility;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.FileContents;
import com.puppycrawl.tools.checkstyle.api.Scope;
import java.util.Arrays;
import java.util.List;
import org.sonar.java.ast.visitor.AstUtils;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.squid.api.SourceCode;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.measures.MetricDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PublicApiVisitor
extends JavaAstVisitor {
    static final String OVERRIDE_ANNOTATION_KEYWORD = "Override";
    public static final List<Integer> TOKENS = Arrays.asList(14, 15, 9, 8, 157, 161, 10);

    @Override
    public List<Integer> getWantedTokens() {
        return TOKENS;
    }

    @Override
    public void visitToken(DetailAST ast) {
        SourceCode currentResource = this.peekSourceCode();
        if (PublicApiVisitor.isPublicApi(ast)) {
            currentResource.add((MetricDef)Metric.PUBLIC_API, 1.0);
            if (this.isDocumentedApi(ast)) {
                currentResource.add((MetricDef)Metric.PUBLIC_DOC_API, 1.0);
            }
        }
    }

    private static boolean isEmptyDefaultConstructor(DetailAST ast) {
        return PublicApiVisitor.isConstructorWithoutParameters(ast) && ast.getLastChild().getChildCount() == 1;
    }

    private static boolean isConstructorWithoutParameters(DetailAST ast) {
        return ast.getType() == 8 && ast.findFirstToken(20).getChildCount() == 0;
    }

    private static boolean isMethodWithOverrideAnnotation(DetailAST ast) {
        if (PublicApiVisitor.isMethod(ast)) {
            return AnnotationUtility.containsAnnotation((DetailAST)ast, (String)OVERRIDE_ANNOTATION_KEYWORD) || AnnotationUtility.containsAnnotation((DetailAST)ast, (String)"java.lang.Override");
        }
        return false;
    }

    private static boolean isMethod(DetailAST ast) {
        return ast.getType() == 9;
    }

    private boolean isDocumentedApi(DetailAST ast) {
        return PublicApiVisitor.isDocumentedApi(ast, this.getFileContents());
    }

    private static boolean isPublic(DetailAST ast) {
        return AstUtils.isScope(AstUtils.getScope(ast), Scope.PUBLIC) || AstUtils.isType(ast, 161);
    }

    private static boolean isStaticFinalVariable(DetailAST ast) {
        return (AstUtils.isClassVariable(ast) || AstUtils.isInterfaceVariable(ast)) && AstUtils.isFinal(ast) && AstUtils.isStatic(ast);
    }

    public static boolean isDocumentedApi(DetailAST ast, FileContents fileContents) {
        return fileContents.getJavadocBefore(ast.getLineNo()) != null;
    }

    public static boolean isPublicApi(DetailAST ast) {
        return PublicApiVisitor.isPublic(ast) && !PublicApiVisitor.isStaticFinalVariable(ast) && !PublicApiVisitor.isMethodWithOverrideAnnotation(ast) && !PublicApiVisitor.isEmptyDefaultConstructor(ast);
    }
}

