/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.check;

import com.google.common.collect.Sets;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.TextBlock;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.java.ast.visitor.AstUtils;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.java.recognizer.JavaFootprint;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.recognizer.CodeRecognizer;
import org.sonar.squid.recognizer.LanguageFootprint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Rule(key="CommentedOutCodeLine", priority=Priority.MAJOR)
public class CommentedOutCodeLineCheck
extends JavaAstVisitor {
    private static final double THRESHOLD = 0.9;
    private static final List<Integer> WANTED_TOKENS = Arrays.asList(15, 14, 157, 154, 9, 8, 10, 155, 161, 16);
    private final CodeRecognizer codeRecognizer = new CodeRecognizer(0.9, (LanguageFootprint)new JavaFootprint());
    private Set<TextBlock> comments;
    private static final String START_JSNI = "/*-{";
    private static final String END_JSNI = "}-*/";

    @Override
    public List<Integer> getWantedTokens() {
        return WANTED_TOKENS;
    }

    @Override
    public void visitFile(DetailAST ast) {
        this.comments = Sets.newHashSet();
        for (TextBlock comment : this.getFileContents().getCppComments().values()) {
            this.comments.add(comment);
        }
        for (List listOfComments : this.getFileContents().getCComments().values()) {
            this.comments.addAll(listOfComments);
        }
    }

    @Override
    public void visitToken(DetailAST ast) {
        TextBlock javadoc;
        if (CommentedOutCodeLineCheck.canBeDocumented(ast) && (javadoc = this.getFileContents().getJavadocBefore(ast.getLineNo())) != null) {
            this.comments.remove(javadoc);
        }
        this.removeJSNIComments(ast);
    }

    private static boolean canBeDocumented(DetailAST ast) {
        if (AstUtils.isType(ast, 10)) {
            return AstUtils.isClassVariable(ast);
        }
        return true;
    }

    @Override
    public void leaveFile(DetailAST ast) {
        SourceFile sourceFile = (SourceFile)this.peekSourceCode();
        block0: for (TextBlock comment : this.comments) {
            String[] lines = comment.getText();
            for (int i = 0; i < lines.length; ++i) {
                if (!this.codeRecognizer.isLineOfCode(lines[i])) continue;
                CheckMessage message = new CheckMessage((Object)this, "This block of commented-out lines of code should be removed.", new Object[0]);
                message.setLine(comment.getStartLineNo() + i);
                sourceFile.log(message);
                continue block0;
            }
        }
        this.comments = null;
    }

    private void removeJSNIComments(DetailAST ast) {
        if (AstUtils.isType(ast, 9) && AstUtils.isModifier(ast, 66)) {
            DetailAST endOfParameterList = ast.findFirstToken(20).getNextSibling();
            DetailAST trailingSemicolon = ast.getLastChild();
            for (int lineNumber = endOfParameterList.getLineNo(); lineNumber <= trailingSemicolon.getLineNo(); ++lineNumber) {
                List listOfComments = (List)this.getFileContents().getCComments().get((Object)lineNumber);
                if (listOfComments == null) continue;
                for (TextBlock comment : listOfComments) {
                    if (!this.isJSNI(comment) || !CommentedOutCodeLineCheck.isCommentBetween(comment, endOfParameterList, trailingSemicolon)) continue;
                    this.comments.remove(comment);
                }
            }
        }
    }

    private static boolean isCommentBetween(TextBlock comment, DetailAST start, DetailAST end) {
        return comment.intersects(start.getLineNo(), start.getColumnNo(), end.getLineNo(), end.getColumnNo());
    }

    private boolean isJSNI(TextBlock comment) {
        String[] lines = comment.getText();
        String firstLine = lines[0];
        String lastLine = lines[lines.length - 1];
        return StringUtils.startsWith((String)firstLine, (String)START_JSNI) && StringUtils.endsWith((String)lastLine, (String)END_JSNI);
    }
}

