/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.ast.visitor;

import com.puppycrawl.tools.checkstyle.api.DetailAST;
import org.sonar.api.measures.FileLinesContext;
import org.sonar.java.ast.visitor.JavaAstVisitor;
import org.sonar.plugins.squid.SonarAccessor;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.measures.Metric;
import org.sonar.squid.text.Source;

public class FileLinesVisitor
extends JavaAstVisitor {
    private final SonarAccessor sonarAccessor;

    public FileLinesVisitor() {
        this.sonarAccessor = null;
    }

    public FileLinesVisitor(SonarAccessor sonarAccessor) {
        this.sonarAccessor = sonarAccessor;
    }

    public void visitFile(DetailAST ast) {
        if (this.sonarAccessor != null) {
            this.processFile();
        }
    }

    private void processFile() {
        SourceFile file = (SourceFile)this.peekSourceCode();
        FileLinesContext measures = this.sonarAccessor.createFileLinesContext(file);
        Source source = this.getSource();
        for (int line = 1; line <= source.getNumberOfLines(); ++line) {
            int lineOfCode = source.getMeasure(Metric.LINES_OF_CODE, line, line);
            measures.setIntValue("ncloc_data", line, lineOfCode);
            int comment = source.getMeasure(Metric.COMMENT_LINES, line, line);
            measures.setIntValue("comment_lines_data", line, comment);
        }
        measures.save();
    }
}

