/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.squid.decorators;

import org.sonar.api.batch.Decorator;
import org.sonar.api.batch.DecoratorContext;
import org.sonar.api.batch.DependedUpon;
import org.sonar.api.batch.DependsUpon;
import org.sonar.api.measures.CoreMetrics;
import org.sonar.api.measures.Measure;
import org.sonar.api.measures.Metric;
import org.sonar.api.measures.RangeDistributionBuilder;
import org.sonar.api.resources.Project;
import org.sonar.api.resources.Resource;
import org.sonar.api.resources.Scopes;

public final class ChidamberKemererDistributionBuilder
implements Decorator {
    private static final Integer[] LCOM4_LIMITS = new Integer[]{2, 3, 4, 5, 10};
    private static final Integer[] RFC_LIMITS = new Integer[]{0, 5, 10, 20, 30, 50, 90, 150};

    @DependedUpon
    public Metric generatesLcom4Distribution() {
        return CoreMetrics.LCOM4_DISTRIBUTION;
    }

    @DependsUpon
    public Metric dependsInLcom4() {
        return CoreMetrics.LCOM4;
    }

    @DependedUpon
    public Metric generatesRfcDistribution() {
        return CoreMetrics.RFC_DISTRIBUTION;
    }

    @DependsUpon
    public Metric dependsInRfc() {
        return CoreMetrics.RFC;
    }

    public void decorate(Resource resource, DecoratorContext context) {
        if (this.shouldExecuteOn(resource)) {
            RangeDistributionBuilder lcom4Distribution = new RangeDistributionBuilder(CoreMetrics.LCOM4_DISTRIBUTION, (Number[])LCOM4_LIMITS);
            RangeDistributionBuilder rfcDistribution = new RangeDistributionBuilder(CoreMetrics.RFC_DISTRIBUTION, (Number[])RFC_LIMITS);
            for (DecoratorContext childContext : context.getChildren()) {
                if (!Scopes.isFile((Resource)childContext.getResource())) continue;
                this.addMeasureToDistribution(childContext, lcom4Distribution, CoreMetrics.LCOM4);
                this.addMeasureToDistribution(childContext, rfcDistribution, CoreMetrics.RFC);
            }
            this.saveDistribution(context, lcom4Distribution);
            this.saveDistribution(context, rfcDistribution);
        }
    }

    private void addMeasureToDistribution(DecoratorContext childContext, RangeDistributionBuilder distribution, Metric metric) {
        Measure measure = childContext.getMeasure(metric);
        if (measure != null) {
            distribution.add((Number)measure.getIntValue());
        }
    }

    private void saveDistribution(DecoratorContext context, RangeDistributionBuilder distribution) {
        Measure measure = distribution.build(false);
        if (measure != null) {
            context.saveMeasure(measure);
        }
    }

    boolean shouldExecuteOn(Resource resource) {
        return Scopes.isDirectory((Resource)resource);
    }

    public boolean shouldExecuteOnProject(Project project) {
        return "java".equals(project.getLanguageKey());
    }
}

