/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.java.squid.check;

import org.sonar.check.Priority;
import org.sonar.check.Rule;
import org.sonar.check.RuleProperty;
import org.sonar.java.squid.check.SquidCheck;
import org.sonar.squid.api.CheckMessage;
import org.sonar.squid.api.SourceFile;
import org.sonar.squid.api.SourceMethod;
import org.sonar.squid.measures.Metric;

@Rule(key="MethodCyclomaticComplexity", priority=Priority.MAJOR)
public class MethodComplexityCheck
extends SquidCheck {
    public static final int DEFAULT_MAX = 10;
    @RuleProperty(defaultValue="10")
    private Integer max = 10;

    public void visitMethod(SourceMethod sourceMethod) {
        int complexity = sourceMethod.getInt(Metric.COMPLEXITY);
        if (complexity > this.max) {
            CheckMessage message = new CheckMessage((Object)this, "The Cyclomatic Complexity of this method is " + complexity + " which is greater than " + this.max + " authorized.", new Object[0]);
            message.setLine(sourceMethod.getStartAtLine());
            message.setCost((double)(complexity - this.max));
            ((SourceFile)sourceMethod.getParent(SourceFile.class)).log(message);
        }
    }

    public void setMax(int max) {
        this.max = max;
    }
}

