/*
 * Decompiled with CFR 0.152.
 */
package org.dotwebstack.framework.test;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.vocabulary.XMLSchema;

public final class DBEERPEDIA {
    public static final String NAMESPACE = "http://dbeerpedia.org#";
    public static final Literal BASE_PATH;
    public static final String TITLE = "Dbeerpedia";
    public static final IRI NAME;
    public static final IRI FOUNDATION;
    public static final IRI SINCE;
    public static final IRI PLACE;
    public static final IRI FTE;
    public static final String BREWERY_DAVO_NAME = "Davo Bieren Deventer";
    public static final Literal BREWERY_DAVO;
    public static final String OBJECT_NAMESPACE = "http://dbeerpedia.org/id/";
    public static final IRI PATH_PATTERN;
    public static final Literal DOMAIN;
    public static final Literal DOMAIN_NL;
    public static final IRI BACKEND;
    public static final IRI SECOND_BACKEND;
    public static final Literal ENDPOINT;
    public static final IRI BREWERIES;
    public static final IRI TUPLE_BREWERIES;
    public static final IRI GRAPH_BREWERIES;
    public static final Literal BREWERIES_LABEL;
    public static final Literal WINERIES_LABEL;
    public static final Literal SELECT_ALL_QUERY;
    public static final Literal CONSTRUCT_ALL_QUERY;
    public static final Literal ASK_ALL_QUERY;
    public static final Literal ASK2_ALL_QUERY;
    public static final Literal MALFORMED_QUERY;
    public static final IRI BROUWTOREN;
    public static final Literal BROUWTOREN_NAME;
    public static final Literal BROUWTOREN_YEAR_OF_FOUNDATION;
    public static final Literal BROUWTOREN_DATE_OF_FOUNDATION;
    public static final Literal BROUWTOREN_PLACE;
    public static final Literal BROUWTOREN_CRAFT_MEMBER;
    public static final Literal BROUWTOREN_FTE;
    public static final Literal BROUWTOREN_LITERS_PER_YEAR;
    public static final IRI MAXIMUS;
    public static final Literal MAXIMUS_NAME;
    public static final Literal MAXIMUS_YEAR_OF_FOUNDATION;
    public static final Literal MAXIMUS_DATE_OF_FOUNDATION;
    public static final Literal MAXIMUS_PLACE;
    public static final Literal MAXIMUS_FTE;
    public static final IRI PERCENTAGES_INFORMATION_PRODUCT;
    public static final IRI ORIGIN_INFORMATION_PRODUCT;
    public static final IRI GRAPH_BREWERY_LIST_REPRESENTATION;
    public static final IRI TUPLE_BREWERY_LIST_REPRESENTATION;
    public static final IRI BREWERY_REPRESENTATION;
    public static final IRI ID2DOC_REDIRECTION;
    public static final IRI ID2DOC_DUMMY_REDIRECTION;
    public static final IRI SUBJECT_FROM_URL;
    public static final Literal SUBJECT_FROM_PATH_PATTERN;
    public static final Literal SUBJECT_FROM_URL_TEMPLATE;
    public static final String SUBJECT_PARAMETER_NAME = "SubjectParameter";
    public static final IRI SUBJECT_PARAMETER;
    public static final Literal ID2DOC_PATH_PATTERN;
    public static final Literal ID2DOC_REDIRECT_TEMPLATE;
    public static final String BREWERY_ID_PATH = "/id/brewery";
    public static final String BREWERY_DOC_PATH = "/doc/brewery";
    public static final IRI BREWERY_APPEARANCE;
    public static final IRI CUSTOM_APPEARANCE_PROP;
    public static final String OPENAPI_DESCRIPTION = "DBeerpedia API";
    public static final String OPENAPI_HOST = "dbpeerpedia.org";
    public static final String OPENAPI_BASE_PATH = "/api/v1";
    public static final String ORG_HOST = "dbeerpedia.org";
    public static final String NL_HOST = "dbeerpedia.nl";
    public static final String SYSTEM_GRAPH = "http://dbeerpedia.nl/configuration/Theatre";
    public static final String RESOURCE_PATH = "file:./config";
    public static final IRI SYSTEM_GRAPH_IRI;
    public static final IRI SITE;
    public static final IRI SITE_NL;
    public static final IRI STAGE;
    public static final IRI SECOND_STAGE;
    public static final String NAME_PARAMETER = "nameParameter";
    public static final IRI NAME_PARAMETER_ID;
    public static final Literal NAME_PARAMETER_VALUE;
    public static final String NAME_PARAMETER_VALUE_STRING;
    public static final IRI PLACE_PARAMETER_ID;
    public static final Literal PLACE_PARAMETER_VALUE;
    public static final String PLACE_PARAMETER_VALUE_STRING;
    public static final String PATH_PATTERN_VALUE = "/holyBeer";
    public static final IRI BREWERY_TYPE;
    public static final IRI WINERY_TYPE;
    public static final IRI LAYOUT;
    public static final IRI LAYOUT_NL;
    public static final Literal LAYOUT_VALUE;
    public static final Literal LAYOUT_NL_VALUE;
    public static final IRI DOC_ENDPOINT;
    public static final IRI DEFAULT_ENDPOINT;
    public static final IRI PERSISTENCE_STEP;
    public static final IRI ASSERTION_IF_EXIST_STEP;
    public static final IRI ASSERTION_IF_NOT_EXIST_STEP;
    public static final IRI UPDATE_STEP;
    public static final IRI PRE_UPDATE_STEP;
    public static final IRI POST_UPDATE_STEP;
    public static final IRI TRANSACTION;
    public static final IRI SEQUENTIAL_FLOW;

    private DBEERPEDIA() {
        throw new IllegalStateException(String.format("%s is not meant to be instantiated.", DBEERPEDIA.class));
    }

    private static Date createDate(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        return calendar.getTime();
    }

    static {
        SimpleValueFactory valueFactory = SimpleValueFactory.getInstance();
        SYSTEM_GRAPH_IRI = valueFactory.createIRI(SYSTEM_GRAPH);
        SITE = valueFactory.createIRI(NAMESPACE, "Site");
        STAGE = valueFactory.createIRI(NAMESPACE, "Stage");
        SECOND_STAGE = valueFactory.createIRI(NAMESPACE, "SecondStage");
        DOMAIN = valueFactory.createLiteral(ORG_HOST);
        BASE_PATH = valueFactory.createLiteral("/special");
        NAME_PARAMETER_ID = valueFactory.createIRI(NAMESPACE, NAME_PARAMETER);
        NAME_PARAMETER_VALUE_STRING = "name";
        NAME_PARAMETER_VALUE = valueFactory.createLiteral(NAME_PARAMETER_VALUE_STRING);
        PLACE_PARAMETER_ID = valueFactory.createIRI(NAMESPACE, "placeParameter");
        PLACE_PARAMETER_VALUE_STRING = "place";
        PLACE_PARAMETER_VALUE = valueFactory.createLiteral(PLACE_PARAMETER_VALUE_STRING);
        FOUNDATION = valueFactory.createIRI(NAMESPACE, "Foundation");
        NAME = valueFactory.createIRI(NAMESPACE, "Name");
        SINCE = valueFactory.createIRI(NAMESPACE, "Since");
        PLACE = valueFactory.createIRI(NAMESPACE, "Place");
        FTE = valueFactory.createIRI(NAMESPACE, "FTE");
        BREWERY_DAVO = valueFactory.createLiteral(BREWERY_DAVO_NAME);
        SITE_NL = valueFactory.createIRI(NAMESPACE, "SiteNL");
        DOMAIN_NL = valueFactory.createLiteral(NL_HOST);
        BACKEND = valueFactory.createIRI(NAMESPACE, "Backend");
        SECOND_BACKEND = valueFactory.createIRI(NAMESPACE, "SecondBackend");
        ENDPOINT = valueFactory.createLiteral("http://localhost:8080/sparql", XMLSchema.ANYURI);
        BREWERIES = valueFactory.createIRI(NAMESPACE, "Breweries");
        TUPLE_BREWERIES = valueFactory.createIRI(NAMESPACE, "TupleBreweries");
        GRAPH_BREWERIES = valueFactory.createIRI(NAMESPACE, "GraphBreweries");
        BREWERIES_LABEL = valueFactory.createLiteral("Beer breweries in The Netherlands");
        WINERIES_LABEL = valueFactory.createLiteral("Wineries in The Netherlands");
        MALFORMED_QUERY = valueFactory.createLiteral("CONSTRUCT ?s ?p ?o WHERE { ?s ?p ?o }");
        SELECT_ALL_QUERY = valueFactory.createLiteral("SELECT ?s ?p ?o WHERE { ?s ?p ?o }");
        CONSTRUCT_ALL_QUERY = valueFactory.createLiteral("CONSTRUCT { ?s ?p ?o } WHERE { ?s ?p ?o }");
        ASK_ALL_QUERY = valueFactory.createLiteral("ASK WHERE { ?s ?p ?o }");
        ASK2_ALL_QUERY = valueFactory.createLiteral("ASK WHERE { ?s a ?o }");
        BROUWTOREN = valueFactory.createIRI(OBJECT_NAMESPACE, "brewery/900e5c1c-d292-48c8-b9bd-1baf02ee2d2c");
        BROUWTOREN_NAME = valueFactory.createLiteral("Brouwtoren");
        BROUWTOREN_YEAR_OF_FOUNDATION = valueFactory.createLiteral(2014);
        BROUWTOREN_DATE_OF_FOUNDATION = valueFactory.createLiteral(DBEERPEDIA.createDate(2014, 0, 1));
        BROUWTOREN_CRAFT_MEMBER = valueFactory.createLiteral(true);
        BROUWTOREN_FTE = valueFactory.createLiteral(1.8);
        BROUWTOREN_LITERS_PER_YEAR = valueFactory.createLiteral(Long.MAX_VALUE);
        BROUWTOREN_PLACE = valueFactory.createLiteral("Nijmegen");
        MAXIMUS = valueFactory.createIRI(OBJECT_NAMESPACE, "brewery/0c0d7df2-a830-11e7-abc4-cec278b6b50a");
        MAXIMUS_NAME = valueFactory.createLiteral("Maximus");
        MAXIMUS_YEAR_OF_FOUNDATION = valueFactory.createLiteral(2012);
        MAXIMUS_DATE_OF_FOUNDATION = valueFactory.createLiteral(DBEERPEDIA.createDate(2012, 8, 27));
        MAXIMUS_FTE = valueFactory.createLiteral(2.4);
        MAXIMUS_PLACE = valueFactory.createLiteral("Utrecht");
        LAYOUT_VALUE = valueFactory.createLiteral(NAMESPACE, "stage-layout.css.css");
        LAYOUT_NL_VALUE = valueFactory.createLiteral(NAMESPACE, "stage-nl-layout.css.css");
        PERCENTAGES_INFORMATION_PRODUCT = valueFactory.createIRI(OBJECT_NAMESPACE, "brewery/information/alcohol-percentages");
        ORIGIN_INFORMATION_PRODUCT = valueFactory.createIRI(OBJECT_NAMESPACE, "brewery/information/origins");
        GRAPH_BREWERY_LIST_REPRESENTATION = valueFactory.createIRI(NAMESPACE, "GraphBreweryListRepresentation");
        TUPLE_BREWERY_LIST_REPRESENTATION = valueFactory.createIRI(NAMESPACE, "TupleBreweryListRepresentation");
        BREWERY_REPRESENTATION = valueFactory.createIRI(NAMESPACE, "BreweryRepresentation");
        ID2DOC_REDIRECTION = valueFactory.createIRI(NAMESPACE, "Id2doc");
        ID2DOC_DUMMY_REDIRECTION = valueFactory.createIRI(NAMESPACE, "Id2docDummy");
        ID2DOC_PATH_PATTERN = valueFactory.createLiteral("/id/{resource}");
        ID2DOC_REDIRECT_TEMPLATE = valueFactory.createLiteral("/doc/{resource}");
        SUBJECT_FROM_URL = valueFactory.createIRI(NAMESPACE, "SubjectFromUrl");
        SUBJECT_FROM_PATH_PATTERN = valueFactory.createLiteral("http://{domain}/doc/{reference}");
        SUBJECT_FROM_URL_TEMPLATE = valueFactory.createLiteral("http://dbeerpedia.org/id/{reference}");
        SUBJECT_PARAMETER = valueFactory.createIRI(NAMESPACE, SUBJECT_PARAMETER_NAME);
        BREWERY_APPEARANCE = valueFactory.createIRI(NAMESPACE, "BreweryAppearance");
        CUSTOM_APPEARANCE_PROP = valueFactory.createIRI(NAMESPACE, "customAppearanceProp");
        PATH_PATTERN = valueFactory.createIRI(NAMESPACE, "pathPattern");
        BREWERY_TYPE = valueFactory.createIRI(NAMESPACE, "Brewery");
        WINERY_TYPE = valueFactory.createIRI(NAMESPACE, "Winery");
        LAYOUT = valueFactory.createIRI(NAMESPACE, "BeerLayout");
        LAYOUT_NL = valueFactory.createIRI(NAMESPACE, "BeerLayoutNL");
        DOC_ENDPOINT = valueFactory.createIRI(NAMESPACE, "DocEndpoint");
        DEFAULT_ENDPOINT = valueFactory.createIRI(NAMESPACE, "DefaultEndpoint");
        PERSISTENCE_STEP = valueFactory.createIRI(NAMESPACE, "PersistenceStep");
        ASSERTION_IF_EXIST_STEP = valueFactory.createIRI(NAMESPACE, "AssertIfExists");
        ASSERTION_IF_NOT_EXIST_STEP = valueFactory.createIRI(NAMESPACE, "AssertIfNotExists");
        UPDATE_STEP = valueFactory.createIRI(NAMESPACE, "UpdateStep");
        PRE_UPDATE_STEP = valueFactory.createIRI(NAMESPACE, "PreUpdateStep");
        POST_UPDATE_STEP = valueFactory.createIRI(NAMESPACE, "PostUpdateStep");
        TRANSACTION = valueFactory.createIRI(NAMESPACE, "InsertConcept");
        SEQUENTIAL_FLOW = valueFactory.createIRI(NAMESPACE, "");
    }
}

