/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Properties;

public class Version {
    private static final String VER_PROP = "/org/expath/pkg/repo/tui/version.properties";
    private static Version INSTANCE = null;
    private String myVersion;
    private String myRevision;

    protected Version() {
        InputStream rsrc = Version.class.getResourceAsStream(VER_PROP);
        if (rsrc == null) {
            throw new IllegalStateException("Version properties file does not exist: /org/expath/pkg/repo/tui/version.properties");
        }
        Properties props = new Properties();
        try {
            props.load(rsrc);
            rsrc.close();
        }
        catch (IOException ex) {
            throw new IllegalStateException("Error reading the version properties: /org/expath/pkg/repo/tui/version.properties", ex);
        }
        this.myVersion = props.getProperty("org.expath.pkg.repo.version");
        this.myRevision = props.getProperty("org.expath.pkg.repo.revision");
    }

    public static void main(String[] args) {
        Version.instance().display(System.out);
    }

    public void display(PrintStream out) {
        out.println("EXPath Packaging System standard on-disk repository manager.");
        out.println("Version: " + this.getVersion() + " (revision #" + this.getRevision() + ")");
    }

    public static synchronized Version instance() {
        if (INSTANCE == null) {
            INSTANCE = new Version();
        }
        return INSTANCE;
    }

    public String getVersion() {
        return this.myVersion;
    }

    public String getRevision() {
        return this.myRevision;
    }
}

