/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.FileHelper;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.tools.Logger;
import org.expath.pkg.repo.tools.PackagesTxtFile;
import org.expath.pkg.repo.tools.PackagesXmlFile;

public class FileSystemStorage
extends Storage {
    private static final Logger LOG = Logger.getLogger(FileSystemStorage.class);
    private Path myRoot;
    private Path myPrivate;
    private final PackagesXmlFile myXmlFile;
    private final PackagesTxtFile myTxtFile;
    private boolean myErrorIfNoContentDir = true;

    public FileSystemStorage(Path root) throws PackageException {
        if (root == null) {
            throw new NullPointerException("The repository root directory is null");
        }
        if (!Files.exists(root, new LinkOption[0])) {
            String msg = "The repository root directory does not exist: " + root;
            throw new PackageException(msg);
        }
        if (!Files.isDirectory(root, new LinkOption[0])) {
            String msg = "The repository root directory is not a directory: " + root;
            throw new PackageException(msg);
        }
        this.myRoot = root;
        Path dir = root.resolve(".expath-pkg");
        FileHelper.ensureDir(dir);
        this.myPrivate = dir;
        Path xmlfile = dir.resolve("packages.xml");
        this.myXmlFile = new PackagesXmlFile(xmlfile);
        Path txtfile = dir.resolve("packages.txt");
        this.myTxtFile = new PackagesTxtFile(txtfile);
    }

    public Path getRootDirectory() {
        return this.myRoot;
    }

    @Override
    public boolean isReadOnly() {
        return false;
    }

    @Override
    public Storage.PackageResolver makePackageResolver(String rsrc_name, String abbrev) throws PackageException {
        Path pkg_root = rsrc_name == null ? null : this.myRoot.resolve(rsrc_name);
        return new FileSystemResolver(pkg_root, abbrev, rsrc_name);
    }

    @Override
    public Set<String> listPackageDirectories() throws PackageException {
        return this.myTxtFile.parseDirectories();
    }

    @Override
    public void beforeInstall(boolean force, UserInteractionStrategy interact) throws PackageException {
    }

    @Override
    public Path makeTempDir(String prefix) throws PackageException {
        return FileHelper.makeTempDir(prefix, this.myPrivate);
    }

    @Override
    public boolean packageKeyExists(String key) throws PackageException {
        Path f = this.myRoot.resolve(key);
        return Files.exists(f, new LinkOption[0]);
    }

    @Override
    public void storeInstallDir(Path dir, String key, Package pkg) throws PackageException {
        Path dest = this.myRoot.resolve(key);
        FileHelper.renameTmpDir(dir, dest);
        FileSystemResolver resolver = this.getResolver(pkg);
        resolver.setPkgDir(dest);
    }

    @Override
    public void updatePackageLists(Package pkg) throws PackageException {
        FileSystemResolver resolver = this.getResolver(pkg);
        String dir = resolver.getDirName();
        this.myXmlFile.addPackage(pkg, dir);
        Path txt_file = this.myPrivate.resolve("packages.txt");
        this.myTxtFile.addPackage(pkg, dir);
    }

    @Override
    public void remove(Package pkg) throws PackageException {
        FileSystemResolver resolver = this.getResolver(pkg);
        String dir = resolver.getDirName();
        this.myXmlFile.removePackageByDir(dir);
        this.myTxtFile.removePackageByDir(dir);
        FileHelper.deleteQuietly(resolver.myPkgDir);
    }

    public String toString() {
        return "File system storage in " + this.myRoot.toAbsolutePath();
    }

    public void setErrorIfNoContentDir(boolean value) {
        this.myErrorIfNoContentDir = value;
    }

    private FileSystemResolver getResolver(Package pkg) throws PackageException {
        Storage.PackageResolver base_resolver = pkg.getResolver();
        if (!(base_resolver instanceof FileSystemResolver)) {
            throw new PackageException("The package has not been installed in this storage.");
        }
        return (FileSystemResolver)base_resolver;
    }

    public class FileSystemResolver
    extends Storage.PackageResolver {
        private final String myRsrcName;
        private final String myPkgAbbrev;
        private Path myPkgDir;
        private Path myContentDir;

        public FileSystemResolver(Path pkg_dir, String abbrev, String rsrc_name) throws PackageException {
            this.myPkgAbbrev = abbrev;
            this.myRsrcName = rsrc_name;
            this.setPkgDir(pkg_dir);
        }

        @Override
        public String getResourceName() {
            return this.myRsrcName;
        }

        @Override
        public URI getContentDirBaseURI() {
            return this.myContentDir.toUri();
        }

        private void setPkgDir(Path dir) throws PackageException {
            this.myPkgDir = dir;
            this.myContentDir = dir == null || this.myPkgAbbrev == null ? null : this.getContenDir(dir, this.myPkgAbbrev);
        }

        private Path getContenDir(Path pkg_dir, String abbrev) throws PackageException {
            Path old_style = pkg_dir.resolve(abbrev);
            Path new_style = pkg_dir.resolve("content");
            boolean old_exists = Files.exists(old_style, new LinkOption[0]);
            boolean new_exists = Files.exists(new_style, new LinkOption[0]);
            boolean old_isdir = Files.isDirectory(old_style, new LinkOption[0]);
            boolean new_isdir = Files.isDirectory(new_style, new LinkOption[0]);
            LOG.trace("Content dir ''{0}'' (exists:{1}/isdir:{2}), and ''{3}'' (exists:{4}/isdir:{5})", new_style, new_exists, new_isdir, old_style, old_exists, old_isdir);
            if (!old_exists && !new_exists) {
                String msg = "None of content dirs exist: '" + new_style + "' and '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                if (FileSystemStorage.this.myErrorIfNoContentDir) {
                    throw new PackageException(msg);
                }
                return null;
            }
            if (old_exists && new_exists) {
                String msg = "Both content dirs exist: '" + new_style + "' and '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                throw new PackageException(msg);
            }
            if (new_exists) {
                if (!new_isdir) {
                    String msg = "Content dir is not a directory: '" + new_style + "'";
                    LOG.info(msg, new Object[0]);
                    throw new PackageException(msg);
                }
                return new_style;
            }
            if (!old_isdir) {
                String msg = "Content dir is not a directory: '" + old_style + "'";
                LOG.info(msg, new Object[0]);
                throw new PackageException(msg);
            }
            LOG.info("Warning: package uses old-style content dir: ''{0}''", old_style);
            return old_style;
        }

        public Path resolveResourceAsFile(String path) {
            return this.myPkgDir.resolve(path);
        }

        public Path resolveComponentAsFile(String path) {
            if (this.myContentDir == null) {
                return null;
            }
            return this.myContentDir.resolve(path);
        }

        @Override
        public StreamSource resolveResource(String path) throws PackageException, Storage.NotExistException {
            return this.resolveWithin(path, this.myPkgDir);
        }

        @Override
        public StreamSource resolveComponent(String path) throws PackageException, Storage.NotExistException {
            if (this.myContentDir == null) {
                return null;
            }
            return this.resolveWithin(path, this.myContentDir);
        }

        private StreamSource resolveWithin(String path, Path dir) throws PackageException, Storage.NotExistException {
            LOG.debug("Trying to resolve ''{0}'' within ''{1}''", path, dir);
            Path f = dir.resolve(path);
            if (!Files.exists(f, new LinkOption[0])) {
                String msg = "File '" + f + "' does not exist";
                LOG.debug(msg, new Object[0]);
                throw new Storage.NotExistException(msg);
            }
            try {
                InputStream in = Files.newInputStream(f, new OpenOption[0]);
                StreamSource src = new StreamSource(in);
                src.setSystemId(f.toUri().toString());
                return src;
            }
            catch (IOException ex) {
                String msg = "File '" + f + "' exists but is not found";
                LOG.error(msg, new Object[0]);
                throw new PackageException(msg, ex);
            }
        }

        private String getDirName() {
            return this.myPkgDir.getFileName().toString();
        }
    }
}

