/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.xml.transform.Source;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.Universe;
import org.expath.pkg.repo.deps.Semver;
import org.expath.pkg.repo.tools.Logger;

public class Packages
implements Universe {
    private String myName;
    private List<Package> myPackages = new ArrayList<Package>();
    private static final Logger LOG = Logger.getLogger(Packages.class);

    public Packages(String name) {
        this.myName = name;
    }

    public String name() {
        return this.myName;
    }

    public Collection<Package> packages() {
        return this.myPackages;
    }

    public Package latest() {
        if (this.myPackages.isEmpty()) {
            return null;
        }
        return this.myPackages.get(0);
    }

    public void add(Package pkg) {
        int i = 0;
        for (Package curr : this.myPackages) {
            if (Packages.lower(curr, pkg)) break;
            ++i;
        }
        this.myPackages.add(i, pkg);
    }

    public Package version(String version) {
        for (Package p : this.myPackages) {
            if (!p.getVersion().equals(version)) continue;
            return p;
        }
        return null;
    }

    public void remove(Package pkg) {
        this.myPackages.remove(pkg);
    }

    @Override
    public Source resolve(String href, URISpace space) throws PackageException {
        return this.resolve(href, space, true);
    }

    @Override
    public Source resolve(String href, URISpace space, boolean transitive) throws PackageException {
        LOG.debug("Package, resolve in {0}: ''{1}'' ({2})", new Object[]{space, href, transitive});
        return this.latest().resolve(href, space, transitive);
    }

    private static boolean lower(Package lhs, Package rhs) {
        try {
            Semver lver = Semver.parse(lhs.getVersion());
            Semver rver = Semver.parse(rhs.getVersion());
            return lver.matchesMin(rver);
        }
        catch (PackageException ex) {
            return true;
        }
    }
}

