/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.resolver;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.Universe;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PkgEntityResolver
implements EntityResolver {
    private Universe myUniverse;
    private URISpace mySpace;

    public PkgEntityResolver(Universe universe, URISpace space) {
        this.myUniverse = universe;
        this.mySpace = space;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        Source resolved;
        try {
            resolved = this.myUniverse.resolve(systemId, this.mySpace);
        }
        catch (PackageException ex) {
            System.err.println("TODO: Error management. Something wrong in entity resolver...");
            ex.printStackTrace();
            return null;
        }
        if (resolved == null) {
            return null;
        }
        InputSource src = this.sourceToInputSource(resolved);
        src.setSystemId(resolved.getSystemId());
        return src;
    }

    private InputSource sourceToInputSource(Source src) throws IOException {
        if (src instanceof SAXSource) {
            SAXSource sax = (SAXSource)src;
            return sax.getInputSource();
        }
        if (src instanceof DOMSource) {
            ByteArrayOutputStream buffer = new ByteArrayOutputStream();
            DOMSource dom = (DOMSource)src;
            Node node = dom.getNode();
            if (node instanceof Document) {
                Document doc = (Document)node;
                node = doc.getDocumentElement();
            }
            Element root = (Element)node;
            this.serialize(root, buffer);
            InputSource result = new InputSource(src.getSystemId());
            result.setByteStream(new ByteArrayInputStream(buffer.toByteArray()));
            return result;
        }
        if (src instanceof StreamSource) {
            StreamSource ss = (StreamSource)src;
            InputSource result = new InputSource(ss.getSystemId());
            result.setByteStream(ss.getInputStream());
            result.setCharacterStream(ss.getReader());
            result.setPublicId(ss.getPublicId());
            return result;
        }
        return new InputSource(src.getSystemId());
    }

    private void serialize(Element element, OutputStream out) throws IOException {
        try {
            DOMSource source = new DOMSource(element);
            StreamResult result = new StreamResult(out);
            TransformerFactory transFactory = TransformerFactory.newInstance();
            Transformer transformer = transFactory.newTransformer();
            transformer.transform(source, result);
        }
        catch (TransformerException ex) {
            throw new IOException("Error serializing in memory...", ex);
        }
    }
}

