/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.tools;

import java.io.IOException;
import java.io.Writer;
import java.nio.file.Path;
import javax.xml.transform.Transformer;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.tools.UpdatableXmlFile;

public class PackagesXmlFile
extends UpdatableXmlFile {
    private static final String ADD_PACKAGE_XSL = "org/expath/pkg/repo/rsrc/add-package.xsl";
    private static final String REMOVE_PACKAGE_XSL = "org/expath/pkg/repo/rsrc/remove-package.xsl";

    public PackagesXmlFile(Path file) throws PackageException {
        super(file);
    }

    public void addPackage(Package pkg, String dir) throws PackageException {
        Transformer trans = this.compile(ADD_PACKAGE_XSL);
        trans.setParameter("name", pkg.getName());
        trans.setParameter("dir", dir);
        trans.setParameter("version", pkg.getVersion());
        this.transform(trans);
    }

    public void removePackageByDir(String dir) throws PackageException {
        Transformer trans = this.compile(REMOVE_PACKAGE_XSL);
        trans.setParameter("dir", dir);
        this.transform(trans);
    }

    @Override
    protected void createEmpty(Writer out) throws IOException {
        out.write("<packages xmlns=\"http://expath.org/ns/repo/packages\"/>\n");
    }
}

