/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.expath.pkg.repo.XarSource;

public class XarFileSource
implements XarSource {
    private final Path xarFile;

    public XarFileSource(Path xarFile) {
        this.xarFile = xarFile;
    }

    @Override
    public URI getURI() {
        return this.xarFile.toUri();
    }

    @Override
    public boolean isValid() {
        return Files.exists(this.xarFile, new LinkOption[0]) && !Files.isDirectory(this.xarFile, new LinkOption[0]);
    }

    @Override
    public InputStream newInputStream() throws IOException {
        return Files.newInputStream(this.xarFile, new OpenOption[0]);
    }
}

