/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.util.Set;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.Storage;
import org.expath.pkg.repo.UserInteractionStrategy;
import org.expath.pkg.repo.tools.PackagesTxtFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClasspathStorage
extends Storage {
    private final String myRoot;
    private static final Logger LOG = LoggerFactory.getLogger(ClasspathStorage.class);

    public ClasspathStorage(String root) {
        this.myRoot = root;
    }

    @Override
    public boolean isReadOnly() {
        return true;
    }

    @Override
    public Storage.PackageResolver makePackageResolver(String rsrc_name, String abbrev) throws PackageException {
        String pkg_root = this.myRoot.replace('.', '/') + "/" + rsrc_name + "/";
        return new ClasspathResolver(pkg_root, abbrev, rsrc_name);
    }

    @Override
    public Set<String> listPackageDirectories() throws PackageException {
        String rsrc = this.myRoot.replace('.', '/') + "/.expath-pkg/packages.txt";
        ClassLoader loader = ClasspathStorage.class.getClassLoader();
        InputStream res = loader.getResourceAsStream(rsrc);
        LOG.debug("Resolve resource .expath-pkg/packages.txt to '{}'", (Object)res);
        return PackagesTxtFile.parseDirectories(res);
    }

    @Override
    public void beforeInstall(boolean force, UserInteractionStrategy interact) throws PackageException {
        throw new UnsupportedOperationException("Classpath storage is read only.");
    }

    @Override
    public Path makeTempDir(String prefix) throws PackageException {
        throw new UnsupportedOperationException("Classpath storage is read only.");
    }

    @Override
    public boolean packageKeyExists(String key) throws PackageException {
        throw new UnsupportedOperationException("Could be implemented on classpath storage, but is only used to install...");
    }

    @Override
    public void storeInstallDir(Path dir, String key, Package pkg) throws PackageException {
        throw new UnsupportedOperationException("Classpath storage is read only.");
    }

    @Override
    public void updatePackageLists(Package pkg) throws PackageException {
        throw new UnsupportedOperationException("Classpath storage is read only.");
    }

    @Override
    public void remove(Package pkg) throws PackageException {
        throw new UnsupportedOperationException("Classpath storage is read only.");
    }

    public String toString() {
        return "Classpath storage in " + this.myRoot;
    }

    public static class ClasspathResolver
    extends Storage.PackageResolver {
        private final String myPkgRoot;
        private final String myContent;
        private final String myRsrcName;
        private final ClassLoader myLoader;

        public ClasspathResolver(String pkg_root, String abbrev, String rsrc_name) throws PackageException {
            this.myPkgRoot = pkg_root;
            this.myRsrcName = rsrc_name;
            this.myLoader = ClasspathResolver.class.getClassLoader();
            this.myContent = ClasspathResolver.getContent(this.myLoader, pkg_root, abbrev);
        }

        @Override
        public URI getContentDirBaseURI() throws PackageException {
            URI uri;
            String rsrc = this.myPkgRoot + "expath-pkg.xml";
            URL sysid = this.myLoader.getResource(rsrc);
            if (sysid == null) {
                throw new PackageException("The package descriptor exists, but has no URL: " + rsrc);
            }
            try {
                uri = sysid.toURI();
            }
            catch (URISyntaxException ex) {
                String msg = "The package descriptor exists, but has an invalid URI: ";
                throw new PackageException(msg + sysid + ", for " + rsrc, ex);
            }
            return uri.resolve("content/");
        }

        private static String getContent(ClassLoader loader, String pkg_root, String abbrev) throws PackageException {
            String old_style = pkg_root + abbrev + "/";
            String new_style = pkg_root + "content/";
            URL old_url = loader.getResource(old_style);
            URL new_url = loader.getResource(new_style);
            LOG.trace("Content dir '{}' is '{}', and '{}' is '{}'", new Object[]{new_style, new_url, old_style, old_url});
            if (old_url == null && new_url == null) {
                String msg = "None of content dirs exist: '" + new_style + "' and '" + old_style + "'";
                LOG.info(msg);
                throw new PackageException(msg);
            }
            if (old_url != null && new_url != null) {
                String msg = "Both content dirs exist: '" + new_style + "' and '" + old_style + "'";
                LOG.info(msg);
                throw new PackageException(msg);
            }
            if (old_url == null) {
                return new_style;
            }
            LOG.info("Warning: package uses old-style content dir: '{}'", (Object)old_style);
            return old_style;
        }

        @Override
        public String getResourceName() {
            return this.myRsrcName;
        }

        @Override
        public StreamSource resolveResource(String path) throws PackageException {
            return this.resolveWithin(path, this.myPkgRoot);
        }

        @Override
        public StreamSource resolveComponent(String path) throws PackageException {
            return this.resolveWithin(path, this.myContent);
        }

        private StreamSource resolveWithin(String path, String root) throws PackageException {
            String rsrc;
            InputStream in;
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            if ((in = this.myLoader.getResourceAsStream(rsrc = root + path)) == null) {
                return null;
            }
            URL sysid = this.myLoader.getResource(rsrc);
            if (sysid == null) {
                throw new PackageException("The resource exists, but has no URL: " + rsrc);
            }
            StreamSource src = new StreamSource(in);
            src.setSystemId(sysid.toString());
            return src;
        }
    }
}

