/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.expath.pkg.repo.PackageException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileHelper {
    private static final SimpleFileVisitor<Path> deleteDirVisitor = new DeleteDirVisitor();
    private static final Logger LOG = LoggerFactory.getLogger(FileHelper.class);

    public static void ensureDir(Path dir) throws PackageException {
        if (!Files.exists(dir, new LinkOption[0])) {
            try {
                Files.createDirectories(dir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new PackageException("Error creating the directory: " + dir, e);
            }
        } else if (!Files.isDirectory(dir, new LinkOption[0])) {
            throw new PackageException("The directory is not a directory: " + dir);
        }
    }

    public static Path makeTempDir(String prefix, Path parent) throws PackageException {
        Date now = new Date();
        SimpleDateFormat fmt = new SimpleDateFormat("yyyyMMdd");
        String today = fmt.format(now);
        try {
            return Files.createTempDirectory(parent, prefix + "-" + today + "-", new FileAttribute[0]);
        }
        catch (IOException ex) {
            throw new PackageException("Error creating a temporary file", ex);
        }
    }

    public static void renameTmpDir(Path from, Path to) throws PackageException {
        block5: {
            try {
                Files.move(from, to, new CopyOption[0]);
            }
            catch (IOException e) {
                if (!System.getProperty("os.name").startsWith("Windows")) {
                    throw new PackageException("Renaming '" + from + "' to '" + to + "' failed", e);
                }
                try {
                    FileHelper.copy(from, to);
                }
                catch (IOException ioe) {
                    throw new PackageException("Copying '" + from + "' to '" + to + "' failed", ioe);
                }
                boolean res = FileHelper.deleteQuietly(from);
                if (res) break block5;
                System.err.println("Error deleting dir: " + from);
            }
        }
    }

    public static void copy(Path source, Path destination) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            Files.copy(source, destination, new CopyOption[0]);
        } else {
            if (Files.exists(destination, new LinkOption[0]) && !Files.isDirectory(destination, new LinkOption[0])) {
                throw new IOException("Cannot copy a directory to a file");
            }
            Files.walkFileTree(source, FileHelper.copyDirVisitor(source, destination));
        }
    }

    private static final SimpleFileVisitor<Path> copyDirVisitor(Path source, Path destination) throws IOException {
        if (!Files.isDirectory(source, new LinkOption[0])) {
            throw new IOException("source must be a directory");
        }
        if (!Files.isDirectory(destination, new LinkOption[0])) {
            throw new IOException("destination must be a directory");
        }
        return new CopyDirVisitor(source, destination);
    }

    public static boolean deleteQuietly(Path path) {
        try {
            if (!Files.isDirectory(path, new LinkOption[0])) {
                return Files.deleteIfExists(path);
            }
            Files.walkFileTree(path, deleteDirVisitor);
            return true;
        }
        catch (IOException ioe) {
            LOG.info("Failed to delete " + path.toString(), (Throwable)ioe);
            return false;
        }
    }

    public static List<Path> list(Path directory) throws IOException {
        try (Stream<Path> entries = Files.list(directory);){
            List<Path> list = entries.collect(Collectors.toList());
            return list;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isEmpty(Path directory) {
        try (Stream<Path> entries = Files.list(directory);){
            boolean bl = !entries.findFirst().isPresent();
            return bl;
        }
        catch (IOException e) {
            return true;
        }
    }

    private static class DeleteDirVisitor
    extends SimpleFileVisitor<Path> {
        private DeleteDirVisitor() {
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Files.deleteIfExists(file);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            if (exc != null) {
                throw exc;
            }
            Files.deleteIfExists(dir);
            return FileVisitResult.CONTINUE;
        }
    }

    private static class CopyDirVisitor
    extends SimpleFileVisitor<Path> {
        private final Path source;
        private final Path destination;

        public CopyDirVisitor(Path source, Path destination) {
            this.source = source;
            this.destination = destination;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            Path relSourceDir = this.source.relativize(dir);
            Path targetDir = this.destination.resolve(relSourceDir);
            Files.createDirectories(targetDir, new FileAttribute[0]);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            Path relSourceFile = this.source.relativize(file);
            Path targetFile = this.destination.resolve(relSourceFile);
            Files.copy(file, targetFile, new CopyOption[0]);
            return FileVisitResult.CONTINUE;
        }
    }
}

