/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.expath.pkg.repo.XarSource;

class ZipHelper {
    private XarSource myXarSource;

    public ZipHelper(XarSource xarSource) {
        this.myXarSource = xarSource;
    }

    public Path unzipToTmpDir() throws IOException {
        Path tmpdir = Files.createTempDirectory("expath-pkg", new FileAttribute[0]);
        tmpdir.toFile().deleteOnExit();
        this.unzip(tmpdir);
        return tmpdir;
    }

    public void unzip(Path dest_dir) throws IOException {
        if (!Files.exists(dest_dir, new LinkOption[0])) {
            Files.createDirectories(dest_dir, new FileAttribute[0]);
        } else if (!Files.isDirectory(dest_dir, new LinkOption[0])) {
            throw new IOException("Destination is not a directory: " + dest_dir);
        }
        try (ZipInputStream zis = new ZipInputStream(this.myXarSource.newInputStream());){
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                if (entry.isDirectory()) continue;
                Path dest = dest_dir.resolve(entry.getName());
                Path parent = dest.getParent();
                if (!Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                Files.copy(zis, dest, StandardCopyOption.REPLACE_EXISTING);
            }
        }
    }
}

