/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.parser;

import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.expath.pkg.repo.Package;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.parser.PkgComponentHandler;
import org.expath.pkg.repo.parser.XMLStreamHelper;

class PkgHandlerUriFile
implements PkgComponentHandler {
    private URISpace mySpace;
    private String myUriElem;
    private String myAlternateElem;
    private String myFileElem;

    PkgHandlerUriFile(URISpace space, String uri_elem, String file_elem) throws PackageException {
        if (space == null) {
            throw new PackageException("space is null");
        }
        if (uri_elem == null) {
            throw new PackageException("uri_elem is null");
        }
        if (file_elem == null) {
            throw new PackageException("file_elem is null");
        }
        this.mySpace = space;
        this.myUriElem = uri_elem;
        this.myFileElem = file_elem;
    }

    PkgHandlerUriFile(URISpace space, String uri_elem, String alternate_elem, String file_elem) throws PackageException {
        this(space, uri_elem, file_elem);
        if (alternate_elem == null) {
            throw new PackageException("alternate_elem is null");
        }
        this.myAlternateElem = alternate_elem;
    }

    @Override
    public void handleDescription(XMLStreamReader parser, Package pkg, XMLStreamHelper helper) throws PackageException {
        if (this.myAlternateElem == null) {
            helper.ensureNextElement(parser, this.myUriElem);
        } else {
            this.ensureNextElements(parser, this.myUriElem, this.myAlternateElem, helper);
        }
        String href = helper.getElementValue(parser);
        helper.ensureNextElement(parser, this.myFileElem);
        String file = helper.getElementValue(parser);
        pkg.addPublicUri(this.mySpace, href, file);
        try {
            parser.next();
        }
        catch (XMLStreamException ex) {
            throw new PackageException("Error parsing the package descriptor", ex);
        }
    }

    private void ensureNextElements(XMLStreamReader parser, String elem1, String elem2, XMLStreamHelper helper) throws PackageException {
        if (helper.isNextElement(parser, elem1)) {
            return;
        }
        if (helper.isElement(parser, elem2)) {
            return;
        }
        throw new PackageException("The element is neither a pkg:" + elem1 + " nor a pkg:" + elem2 + ": " + parser.getName());
    }
}

