/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.tools;

import java.io.InputStream;
import java.io.StringWriter;
import java.nio.file.Path;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.tools.UpdatableFile;

public abstract class UpdatableXmlFile
extends UpdatableFile {
    public UpdatableXmlFile(Path file) throws PackageException {
        super(file);
    }

    protected Transformer compile(String rsrc_name) throws PackageException {
        try {
            ClassLoader loader = UpdatableXmlFile.class.getClassLoader();
            InputStream style_in = loader.getResourceAsStream(rsrc_name);
            if (style_in == null) {
                throw new PackageException("Resource not found: " + rsrc_name);
            }
            StreamSource style_src = new StreamSource(style_in);
            style_src.setSystemId(rsrc_name);
            Templates style = TransformerFactory.newInstance().newTemplates(style_src);
            return style.newTransformer();
        }
        catch (TransformerConfigurationException ex) {
            throw new PackageException("Impossible to compile the stylesheet: " + rsrc_name, ex);
        }
    }

    protected void transform(Transformer trans) throws PackageException {
        try {
            StreamSource src = new StreamSource(this.myFile.toFile());
            StringWriter res_out = new StringWriter();
            StreamResult res = new StreamResult(res_out);
            trans.transform(src, res);
            this.update(res_out);
        }
        catch (TransformerException ex) {
            throw new PackageException("Error transforming the file: " + this.myFile, ex);
        }
    }
}

