/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo;

import java.util.ArrayList;
import java.util.Collection;
import javax.xml.transform.Source;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.URISpace;
import org.expath.pkg.repo.Universe;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeUniverse
implements Universe {
    private boolean myTransitive;
    private Collection<Universe> mySubUniverses = new ArrayList<Universe>();
    private static final Logger LOG = LoggerFactory.getLogger(CompositeUniverse.class);

    public CompositeUniverse(boolean transitive) {
        this.myTransitive = transitive;
    }

    public void addUniverse(Universe universe) {
        this.mySubUniverses.add(universe);
    }

    @Override
    public Source resolve(String href, URISpace space) throws PackageException {
        return this.resolve(href, space, this.myTransitive);
    }

    @Override
    public Source resolve(String href, URISpace space, boolean transitive) throws PackageException {
        LOG.debug("Composite universe, resolve in {}: '{}' ({})", new Object[]{space, href, transitive});
        for (Universe sub : this.mySubUniverses) {
            Source src = sub.resolve(href, space, transitive);
            if (src == null) continue;
            return src;
        }
        return null;
    }
}

