/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.deps;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.expath.pkg.repo.PackageException;

public class Semver
implements Comparable<Semver> {
    private static final Pattern PTN_SEM_VER = Pattern.compile("([0-9]+)(\\.[0-9]+)?(\\.[0-9]+)?(-[1-9A-Za-z][0-9A-Za-z-]*(?:\\.[1-9A-Za-z][0-9A-Za-z-]*)*)?(\\+[0-9A-Za-z-]+(?:\\.[0-9A-Za-z-]+)*)?");
    private final int majorVersion;
    private final Integer minorVersion;
    private final Integer patchVersion;
    private final String preReleaseVersion;
    private final String buildMetadata;

    public Semver(int majorVersion, Integer minorVersion, Integer patchVersion, String preReleaseVersion, String buildMetadata) {
        this.majorVersion = majorVersion;
        this.minorVersion = minorVersion;
        this.patchVersion = patchVersion;
        this.preReleaseVersion = preReleaseVersion;
        this.buildMetadata = buildMetadata;
    }

    public static Semver parse(String semver) throws PackageException {
        Matcher matcher = PTN_SEM_VER.matcher(semver);
        if (!matcher.matches()) {
            Semver.parseError(semver, "Does not match EXPath SemVer Regex");
        }
        int majorVersion = Integer.parseInt(matcher.group(1));
        Integer minorVersion = null;
        Integer patchVersion = null;
        String preReleaseVersion = null;
        String buildMetadata = null;
        block5: for (int i = 2; i <= matcher.groupCount(); ++i) {
            String group = matcher.group(i);
            if (group == null) continue;
            switch (group.charAt(0)) {
                case '.': {
                    if (minorVersion == null) {
                        minorVersion = Integer.parseInt(group.substring(1));
                        continue block5;
                    }
                    patchVersion = Integer.parseInt(group.substring(1));
                    continue block5;
                }
                case '-': {
                    preReleaseVersion = group.substring(1);
                    continue block5;
                }
                case '+': {
                    buildMetadata = group.substring(1);
                    continue block5;
                }
                default: {
                    Semver.parseError(semver, "Illegal state");
                }
            }
        }
        return new Semver(majorVersion, minorVersion, patchVersion, preReleaseVersion, buildMetadata);
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public Integer getPatchVersion() {
        return this.patchVersion;
    }

    public String getPreReleaseVersion() {
        return this.preReleaseVersion;
    }

    public String getBuildMetadata() {
        return this.buildMetadata;
    }

    public boolean matches(Semver rhs) throws PackageException {
        return this.matchesTemplate(rhs) == 0;
    }

    public boolean matchesMin(Semver rhs) throws PackageException {
        return this.matchesTemplate(rhs) <= 0;
    }

    public boolean matchesMax(Semver rhs) throws PackageException {
        return this.matchesTemplate(rhs) >= 0;
    }

    @Override
    public int compareTo(Semver other) {
        int majorDiff = this.majorVersion - other.majorVersion;
        if (majorDiff != 0) {
            return majorDiff * 1000;
        }
        int minorDiff = Semver.toInt(this.minorVersion) - Semver.toInt(other.minorVersion);
        if (minorDiff != 0) {
            return minorDiff * 100;
        }
        int patchDiff = Semver.toInt(this.patchVersion) - Semver.toInt(other.patchVersion);
        if (patchDiff != 0) {
            return patchDiff * 10;
        }
        if (this.preReleaseVersion == null && other.preReleaseVersion == null) {
            return 0;
        }
        if (this.preReleaseVersion == null) {
            return 1;
        }
        if (other.preReleaseVersion == null) {
            return -1;
        }
        String[] preReleaseIdentfiers = this.preReleaseVersion.split("\\.");
        String[] otherPreReleaseIdentfiers = other.preReleaseVersion.split("\\.");
        for (int i = 0; i < Math.min(preReleaseIdentfiers.length, otherPreReleaseIdentfiers.length); ++i) {
            int preReleaseIdentifierDiff;
            String preReleaseIdentfier = preReleaseIdentfiers[i];
            String otherPreReleaseIdentfier = otherPreReleaseIdentfiers[i];
            boolean preReleaseIdentfierIsNum = Semver.isNumeric(preReleaseIdentfier);
            boolean otherPreReleaseIdentfierIsNum = Semver.isNumeric(otherPreReleaseIdentfier);
            if (preReleaseIdentfierIsNum && otherPreReleaseIdentfierIsNum) {
                preReleaseIdentifierDiff = Integer.parseInt(preReleaseIdentfier) - Integer.parseInt(otherPreReleaseIdentfier);
                if (preReleaseIdentifierDiff == 0) continue;
                return preReleaseIdentifierDiff;
            }
            if (preReleaseIdentfierIsNum) {
                return -1;
            }
            if (otherPreReleaseIdentfierIsNum) {
                return 1;
            }
            preReleaseIdentifierDiff = preReleaseIdentfier.compareTo(otherPreReleaseIdentfier);
            if (preReleaseIdentifierDiff == 0) continue;
            return preReleaseIdentifierDiff;
        }
        return preReleaseIdentfiers.length - otherPreReleaseIdentfiers.length;
    }

    private int matchesTemplate(Semver other) {
        int majorDiff = this.majorVersion - other.majorVersion;
        if (majorDiff != 0) {
            return majorDiff * 1000;
        }
        if (this.minorVersion != null) {
            int minorDiff = this.minorVersion - other.minorVersion;
            if (minorDiff != 0) {
                return minorDiff * 100;
            }
        } else {
            return 0;
        }
        if (this.patchVersion != null) {
            int patchDiff = this.patchVersion - other.patchVersion;
            if (patchDiff != 0) {
                return patchDiff * 10;
            }
        } else {
            return 0;
        }
        if (this.preReleaseVersion == null && other.preReleaseVersion == null) {
            return 0;
        }
        if (this.preReleaseVersion == null) {
            return 1;
        }
        if (other.preReleaseVersion == null) {
            return -1;
        }
        String[] preReleaseIdentfiers = this.preReleaseVersion.split("\\.");
        String[] otherPreReleaseIdentfiers = other.preReleaseVersion.split("\\.");
        for (int i = 0; i < Math.min(preReleaseIdentfiers.length, otherPreReleaseIdentfiers.length); ++i) {
            int preReleaseIdentifierDiff;
            String preReleaseIdentfier = preReleaseIdentfiers[i];
            String otherPreReleaseIdentfier = otherPreReleaseIdentfiers[i];
            boolean preReleaseIdentfierIsNum = Semver.isNumeric(preReleaseIdentfier);
            boolean otherPreReleaseIdentfierIsNum = Semver.isNumeric(otherPreReleaseIdentfier);
            if (preReleaseIdentfierIsNum && otherPreReleaseIdentfierIsNum) {
                preReleaseIdentifierDiff = Integer.parseInt(preReleaseIdentfier) - Integer.parseInt(otherPreReleaseIdentfier);
                if (preReleaseIdentifierDiff == 0) continue;
                return preReleaseIdentifierDiff;
            }
            if (preReleaseIdentfierIsNum) {
                return -1;
            }
            if (otherPreReleaseIdentfierIsNum) {
                return 1;
            }
            preReleaseIdentifierDiff = preReleaseIdentfier.compareTo(otherPreReleaseIdentfier);
            if (preReleaseIdentifierDiff == 0) continue;
            return preReleaseIdentifierDiff;
        }
        return preReleaseIdentfiers.length - otherPreReleaseIdentfiers.length;
    }

    private static int toInt(@Nullable Integer integer) {
        if (integer == null) {
            return 0;
        }
        return integer;
    }

    private static boolean isNumeric(String string) {
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('0' >= c && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static void parseError(String semver, String msg) throws PackageException {
        throw new PackageException("Invalid SemVer '" + semver + "': " + msg);
    }
}

