/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.tools;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.expath.pkg.repo.PackageException;

public abstract class UpdatableFile {
    protected Path myFile;

    public UpdatableFile(Path file) throws PackageException {
        this.myFile = file;
        if (!Files.exists(this.myFile, new LinkOption[0])) {
            this.topCreateEmpty();
        }
    }

    protected abstract void createEmpty(Writer var1) throws IOException;

    protected void update(StringWriter content) throws PackageException {
        try (OutputStream out = Files.newOutputStream(this.myFile, new OpenOption[0]);){
            byte[] bytes = content.getBuffer().toString().getBytes();
            out.write(bytes);
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("File not found: " + this.myFile, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error writing the file: " + this.myFile, ex);
        }
    }

    private void topCreateEmpty() throws PackageException {
        try (BufferedWriter out = Files.newBufferedWriter(this.myFile, new OpenOption[0]);){
            this.createEmpty(out);
        }
        catch (FileNotFoundException ex) {
            throw new PackageException("Impossible to create the packages text list: " + this.myFile, ex);
        }
        catch (IOException ex) {
            throw new PackageException("Error creating the packages text list: " + this.myFile, ex);
        }
    }
}

