/*
 * Decompiled with CFR 0.152.
 */
package org.expath.pkg.repo.tui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.expath.pkg.repo.PackageException;
import org.expath.pkg.repo.UserInteractionStrategy;

public class TextUserInteraction
implements UserInteractionStrategy {
    private boolean myVerbose;
    private BufferedReader myInput;

    public TextUserInteraction(boolean verbose) {
        this.myVerbose = verbose;
        this.myInput = new BufferedReader(new InputStreamReader(System.in));
    }

    @Override
    public void messageInfo(String msg) throws PackageException {
        System.err.println("info: " + msg);
    }

    @Override
    public void messageError(String msg) throws PackageException {
        System.err.println("ERROR: " + msg);
    }

    @Override
    public void logInfo(String msg) throws PackageException {
        if (this.myVerbose) {
            System.err.println("log: " + msg);
        }
    }

    @Override
    public boolean ask(String prompt, boolean dflt) throws PackageException {
        String val;
        System.out.print(prompt + " [" + dflt + "]: ");
        try {
            val = this.myInput.readLine();
        }
        catch (IOException ex) {
            throw new PackageException("Error reading stdin", ex);
        }
        return val == null || val.isEmpty() ? dflt : Boolean.getBoolean(val);
    }

    @Override
    public String ask(String prompt, String dflt) throws PackageException {
        String val;
        System.out.print(prompt + " [" + dflt + "]: ");
        try {
            val = this.myInput.readLine();
        }
        catch (IOException ex) {
            throw new PackageException("Error reading stdin", ex);
        }
        return val == null || val.isEmpty() ? dflt : val;
    }
}

