/*
 * Decompiled with CFR 0.152.
 */
package org.expath.tools.model.dom;

import java.io.OutputStream;
import org.expath.tools.ToolsException;
import org.expath.tools.model.Sequence;
import org.expath.tools.model.dom.DomSingleton;
import org.expath.tools.serial.SerialParameters;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSOutput;
import org.w3c.dom.ls.LSSerializer;

public class DomSequence
implements Sequence {
    private int myNext = 0;
    private final NodeList myNodes;

    public DomSequence(NodeList nodes) {
        this.myNodes = nodes;
    }

    @Override
    public boolean isEmpty() throws ToolsException {
        return this.myNext >= this.myNodes.getLength();
    }

    @Override
    public Sequence next() throws ToolsException {
        Node node = this.myNodes.item(this.myNext++);
        return new DomSingleton(node);
    }

    @Override
    public void serialize(OutputStream out, SerialParameters params) throws ToolsException {
        int length = this.myNodes.getLength();
        if (length == 0) {
            return;
        }
        Document doc = this.myNodes.item(0).getOwnerDocument();
        DOMImplementationLS impl = (DOMImplementationLS)((Object)doc.getImplementation());
        LSSerializer serial = impl.createLSSerializer();
        LSOutput lsout = impl.createLSOutput();
        lsout.setByteStream(out);
        for (int i = 0; i < this.myNodes.getLength(); ++i) {
            serial.write(this.myNodes.item(i), lsout);
        }
    }

    NodeList getUnderlyingNodeList() {
        return this.myNodes;
    }
}

