/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.scripting.secure.behavior;

import org.activiti.engine.ActivitiException;
import org.activiti.engine.delegate.BpmnError;
import org.activiti.engine.delegate.VariableScope;
import org.activiti.engine.impl.bpmn.behavior.ScriptTaskActivityBehavior;
import org.activiti.engine.impl.bpmn.helper.ErrorPropagation;
import org.activiti.engine.impl.pvm.delegate.ActivityExecution;
import org.activiti.scripting.secure.impl.SecureJavascriptUtil;
import org.apache.commons.lang3.exception.ExceptionUtils;

public class SecureJavascriptTaskActivityBehavior
extends ScriptTaskActivityBehavior {
    public SecureJavascriptTaskActivityBehavior(String scriptTaskId, String script, String language, String resultVariable, boolean storeScriptVariables) {
        super(scriptTaskId, script, language, resultVariable, storeScriptVariables);
    }

    public void execute(ActivityExecution execution) throws Exception {
        boolean noErrors = true;
        try {
            Object result = SecureJavascriptUtil.evaluateScript((VariableScope)execution, this.script);
            if (this.resultVariable != null) {
                execution.setVariable(this.resultVariable, result);
            }
        }
        catch (ActivitiException e) {
            noErrors = false;
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause instanceof BpmnError) {
                ErrorPropagation.propagateError((BpmnError)((BpmnError)rootCause), (ActivityExecution)execution);
            }
            throw e;
        }
        if (noErrors) {
            this.leave(execution);
        }
    }
}

