/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.scripting.secure.behavior;

import org.apache.commons.lang3.StringUtils;
import org.flowable.bpmn.model.ScriptTask;
import org.flowable.engine.impl.bpmn.parser.BpmnParse;
import org.flowable.engine.impl.bpmn.parser.handler.ScriptTaskParseHandler;
import org.flowable.scripting.secure.behavior.SecureJavascriptTaskActivityBehavior;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecureJavascriptTaskParseHandler
extends ScriptTaskParseHandler {
    private static final Logger logger = LoggerFactory.getLogger(SecureJavascriptTaskParseHandler.class);
    public static final String LANGUAGE_JAVASCRIPT = "javascript";

    protected void executeParse(BpmnParse bpmnParse, ScriptTask scriptTask) {
        String language = scriptTask.getScriptFormat();
        if (LANGUAGE_JAVASCRIPT.equalsIgnoreCase(language)) {
            this.createSecureJavascriptTaskBehavior(bpmnParse, scriptTask, language);
        } else {
            super.executeParse(bpmnParse, scriptTask);
        }
    }

    protected void createSecureJavascriptTaskBehavior(BpmnParse bpmnParse, ScriptTask scriptTask, String language) {
        if (StringUtils.isEmpty((CharSequence)scriptTask.getScript())) {
            logger.warn("No script provided for scriptTask " + scriptTask.getId());
        }
        scriptTask.setBehavior((Object)new SecureJavascriptTaskActivityBehavior(scriptTask.getId(), scriptTask.getScript(), language, scriptTask.getResultVariable(), scriptTask.isAutoStoreVariables()));
    }
}

