/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.F;
import fj.Unit;
import fj.data.IO;
import fj.data.IOFunctions;
import fj.data.LazyString;
import fj.data.SafeIO;
import fj.data.Validation;
import java.io.IOException;

public final class IOW<A>
implements IO<A> {
    private final IO<A> io;

    private IOW(IO<A> in) {
        this.io = in;
    }

    public static <A> IOW<A> lift(IO<A> io) {
        return new IOW<A>(io);
    }

    @Override
    public A run() throws IOException {
        return this.io.run();
    }

    public SafeIO<Validation<IOException, A>> safe() {
        return IOFunctions.toSafeValidation(this.io);
    }

    public <B> IOW<B> map(F<A, B> f) {
        return IOW.lift(IOFunctions.map(this.io, f));
    }

    public <B> IOW<B> bind(F<A, IO<B>> f) {
        return IOW.lift(IOFunctions.bind(this.io, f));
    }

    public <B> IOW<B> append(IO<B> iob) {
        return IOW.lift(IOFunctions.append(this.io, iob));
    }

    public static IOW<LazyString> getContents() {
        return IOW.lift(() -> IOFunctions.getContents().run());
    }

    public static IOW<Unit> interact(F<LazyString, LazyString> f) {
        return IOW.lift(() -> IOFunctions.interact(f).run());
    }
}

