/*
 * Decompiled with CFR 0.152.
 */
package fj.data;

import fj.Equal;
import fj.F;
import fj.F2;
import fj.F2Functions;
import fj.F3;
import fj.Function;
import fj.Hash;
import fj.Ord;
import fj.P;
import fj.P1;
import fj.P2;
import fj.P3;
import fj.Show;
import fj.data.Option;
import fj.data.Stream;
import fj.function.Integers;
import java.util.Iterator;

public final class Zipper<A>
implements Iterable<Zipper<A>> {
    private final Stream<A> left;
    private final A focus;
    private final Stream<A> right;

    private Zipper(Stream<A> left, A focus, Stream<A> right) {
        this.left = left;
        this.focus = focus;
        this.right = right;
    }

    public static <A> Zipper<A> zipper(Stream<A> left, A focus, Stream<A> right) {
        return new Zipper<A>(left, focus, right);
    }

    public static <A> Zipper<A> zipper(P3<Stream<A>, A, Stream<A>> p) {
        return new Zipper<A>(p._1(), p._2(), p._3());
    }

    public static <A> F3<Stream<A>, A, Stream<A>, Zipper<A>> zipper() {
        return Zipper::zipper;
    }

    public P3<Stream<A>, A, Stream<A>> p() {
        return P.p(this.left, this.focus, this.right);
    }

    public static <A> F<Zipper<A>, P3<Stream<A>, A, Stream<A>>> p_() {
        return Zipper::p;
    }

    public static <A> Ord<Zipper<A>> ord(Ord<A> o) {
        Ord<Stream<A>> so = Ord.streamOrd(o);
        return Ord.p3Ord(so, o, so).contramap(Zipper.p_());
    }

    public final boolean equals(Object other) {
        return Equal.equals0(Zipper.class, this, other, () -> Equal.zipperEqual(Equal.anyEqual()));
    }

    public final int hashCode() {
        return Hash.zipperHash(Hash.anyHash()).hash(this);
    }

    public static <A> Equal<Zipper<A>> eq(Equal<A> e) {
        Equal<Stream<A>> se = Equal.streamEqual(e);
        return Equal.p3Equal(se, e, se).contramap(Zipper.p_());
    }

    public static <A> Show<Zipper<A>> show(Show<A> s) {
        Show<Stream<A>> ss = Show.streamShow(s);
        return Show.p3Show(ss, s, ss).contramap(Zipper.p_());
    }

    public <B> Zipper<B> map(F<A, B> f) {
        return Zipper.zipper(this.left.map(f), f.f(this.focus), this.right.map(f));
    }

    public <B> B foldRight(F<A, F<B, B>> f, B z) {
        return this.left.foldLeft(Function.flip(f), this.right.cons(this.focus).foldRight(Function.compose(Function.andThen().f(P1.__1()), f), z));
    }

    public static <A> Zipper<A> single(A a) {
        return Zipper.zipper(Stream.nil(), a, Stream.nil());
    }

    public static <A> Option<Zipper<A>> fromStream(Stream<A> a) {
        if (a.isEmpty()) {
            return Option.none();
        }
        return Option.some(Zipper.zipper(Stream.nil(), a.head(), a.tail()._1()));
    }

    public static <A> Option<Zipper<A>> fromStreamEnd(Stream<A> a) {
        if (a.isEmpty()) {
            return Option.none();
        }
        Stream<A> xs = a.reverse();
        return Option.some(Zipper.zipper(xs.tail()._1(), xs.head(), Stream.nil()));
    }

    public A focus() {
        return this.focus;
    }

    public Option<Zipper<A>> next() {
        return this.right.isEmpty() ? Option.none() : Option.some(this.tryNext());
    }

    public Zipper<A> tryNext() {
        if (this.right.isEmpty()) {
            throw new Error("Tried next at the end of a zipper.");
        }
        return Zipper.zipper(this.left.cons(this.focus), this.right.head(), this.right.tail()._1());
    }

    public Option<Zipper<A>> previous() {
        return this.left.isEmpty() ? Option.none() : Option.some(this.tryPrevious());
    }

    public Zipper<A> tryPrevious() {
        if (this.left.isEmpty()) {
            throw new Error("Tried previous at the beginning of a zipper.");
        }
        return Zipper.zipper(this.left.tail()._1(), this.left.head(), this.right.cons(this.focus));
    }

    public static <A> F<Zipper<A>, Option<Zipper<A>>> next_() {
        return Zipper::next;
    }

    public static <A> F<Zipper<A>, Option<Zipper<A>>> previous_() {
        return Zipper::previous;
    }

    public Zipper<A> insertLeft(A a) {
        return Zipper.zipper(this.left, a, this.right.cons(this.focus));
    }

    public Zipper<A> insertRight(A a) {
        return Zipper.zipper(this.left.cons(this.focus), a, this.right);
    }

    public Option<Zipper<A>> deleteLeft() {
        return this.left.isEmpty() && this.right.isEmpty() ? Option.none() : Option.some(Zipper.zipper(this.left.isEmpty() ? this.left : this.left.tail()._1(), this.left.isEmpty() ? this.right.head() : this.left.head(), this.left.isEmpty() ? this.right.tail()._1() : this.right));
    }

    public Option<Zipper<A>> deleteRight() {
        return this.left.isEmpty() && this.right.isEmpty() ? Option.none() : Option.some(Zipper.zipper(this.right.isEmpty() ? this.left.tail()._1() : this.left, this.right.isEmpty() ? this.left.head() : this.right.head(), this.right.isEmpty() ? this.right : this.right.tail()._1()));
    }

    public Zipper<A> deleteOthers() {
        Stream nil = Stream.nil();
        return Zipper.zipper(nil, this.focus, nil);
    }

    public int length() {
        return this.foldRight(Function.constant(Integers.add.f(1)), 0);
    }

    public boolean atStart() {
        return this.left.isEmpty();
    }

    public boolean atEnd() {
        return this.right.isEmpty();
    }

    public Zipper<Zipper<A>> positions() {
        Stream left = Stream.unfold(p -> p.previous().map(Function.join(P.p2())), this);
        Stream right = Stream.unfold(p -> p.next().map(Function.join(P.p2())), this);
        return Zipper.zipper(left, this, right);
    }

    public <B> Zipper<B> cobind(F<Zipper<A>, B> f) {
        return this.positions().map(f);
    }

    public Zipper<P2<A, Boolean>> zipWithFocus() {
        return Zipper.zipper(this.left.zip(Stream.repeat(false)), P.p(this.focus, true), this.right.zip(Stream.repeat(false)));
    }

    public Option<Zipper<A>> move(int n) {
        Option<Zipper<Zipper<A>>> p;
        block4: {
            int rl;
            block3: {
                int ll = this.left.length();
                rl = this.right.length();
                p = Option.some(this);
                if (n < 0 || n >= this.length()) {
                    return Option.none();
                }
                if (ll < n) break block3;
                for (int i = ll - n; i > 0; --i) {
                    p = p.bind(Zipper.previous_());
                }
                break block4;
            }
            if (rl < n) break block4;
            for (int i = rl - n; i > 0; --i) {
                p = p.bind(Zipper.next_());
            }
        }
        return p;
    }

    public static <A> F<Integer, F<Zipper<A>, Option<Zipper<A>>>> move() {
        return Function.curry((i, a) -> a.move((int)i));
    }

    public Option<Zipper<A>> find(F<A, Boolean> p) {
        if (p.f(this.focus()).booleanValue()) {
            return Option.some(this);
        }
        Zipper<Zipper<A>> ps = this.positions();
        return ps.lefts().interleave(ps.rights()).find(zipper -> (Boolean)p.f(zipper.focus()));
    }

    public int index() {
        return this.left.length();
    }

    public Zipper<A> cycleNext() {
        if (this.left.isEmpty() && this.right.isEmpty()) {
            return this;
        }
        if (this.right.isEmpty()) {
            Stream<A> xs = this.left.reverse();
            return Zipper.zipper(Stream.nil(), xs.head(), xs.tail()._1().snoc(P.p(this.focus)));
        }
        return this.tryNext();
    }

    public Zipper<A> cyclePrevious() {
        if (this.left.isEmpty() && this.right.isEmpty()) {
            return this;
        }
        if (this.left.isEmpty()) {
            Stream<A> xs = this.right.reverse();
            return Zipper.zipper(xs.tail()._1().snoc(P.p(this.focus)), xs.head(), Stream.nil());
        }
        return this.tryPrevious();
    }

    public Option<Zipper<A>> deleteLeftCycle() {
        if (this.left.isEmpty() && this.right.isEmpty()) {
            return Option.none();
        }
        if (this.left.isNotEmpty()) {
            return Option.some(Zipper.zipper(this.left.tail()._1(), this.left.head(), this.right));
        }
        Stream<A> xs = this.right.reverse();
        return Option.some(Zipper.zipper(xs.tail()._1(), xs.head(), Stream.nil()));
    }

    public Option<Zipper<A>> deleteRightCycle() {
        if (this.left.isEmpty() && this.right.isEmpty()) {
            return Option.none();
        }
        if (this.right.isNotEmpty()) {
            return Option.some(Zipper.zipper(this.left, this.right.head(), this.right.tail()._1()));
        }
        Stream<A> xs = this.left.reverse();
        return Option.some(Zipper.zipper(Stream.nil(), xs.head(), xs.tail()._1()));
    }

    public Zipper<A> replace(A a) {
        return Zipper.zipper(this.left, a, this.right);
    }

    public Stream<A> toStream() {
        return this.left.reverse().snoc(P.p(this.focus)).append(this.right);
    }

    public Stream<A> lefts() {
        return this.left;
    }

    public Stream<A> rights() {
        return this.right;
    }

    public <B, C> Zipper<C> zipWith(Zipper<B> bs, F2<A, B, C> f) {
        return F2Functions.zipZipperM(f).f(this, bs);
    }

    public <B, C> Zipper<C> zipWith(Zipper<B> bs, F<A, F<B, C>> f) {
        return this.zipWith(bs, Function.uncurryF2(f));
    }

    @Override
    public Iterator<Zipper<A>> iterator() {
        return this.positions().toStream().iterator();
    }
}

