/*
 * Decompiled with CFR 0.152.
 */
package org.gitlab.api.query;

import java.io.UnsupportedEncodingException;
import org.gitlab.api.http.Query;

public class PaginationQuery
extends Query {
    public static final String PARAM_PAGE = "page";
    public static final String PARAM_PER_PAGE = "per_page";
    public static final int MAX_ITEMS_PER_PAGE = 100;

    public void setPage(int page) {
        try {
            this.append(PARAM_PAGE, String.valueOf(page));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void setPerPage(int perPage) {
        if (perPage > 100) {
            throw new IllegalArgumentException("Max value for perPage is 100");
        }
        try {
            this.append(PARAM_PER_PAGE, String.valueOf(perPage));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public PaginationQuery withPage(int page) {
        this.setPage(page);
        return this;
    }

    public PaginationQuery withPerPage(int perPage) {
        this.setPerPage(perPage);
        return this;
    }
}

