/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.java;

import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.util.Set;
import lombok.Generated;
import net.bytebuddy.agent.ByteBuddyAgent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Instrumentations {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(Instrumentations.class);

    private Instrumentations() {
    }

    public static Instrumentation get() {
        return ByteBuddyAgent.install();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void retransformClasses(Instrumentation inst, ClassFileTransformer transformer, Set<Class<?>> classes) {
        try {
            inst.addTransformer(transformer, true);
            for (Class<?> clazz : classes) {
                if (Instrumentations.isLambdaClass(clazz)) {
                    logger.info("ignore lambda class: {}, because jdk do not support retransform lambda class: https://github.com/alibaba/arthas/issues/1512.", (Object)clazz.getName());
                    continue;
                }
                try {
                    inst.retransformClasses(clazz);
                }
                catch (Exception e) {
                    String errorMsg = "retransform Classes class error, name: " + clazz.getName();
                    logger.error(errorMsg, (Throwable)e);
                }
            }
        }
        finally {
            inst.removeTransformer(transformer);
        }
    }

    public static boolean isLambdaClass(Class<?> clazz) {
        return clazz.getName().contains("$$Lambda$");
    }
}

