/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.java.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.ifinalframework.java.compiler.DynamicClassLoader;
import org.ifinalframework.java.compiler.DynamicCompilerException;
import org.ifinalframework.java.compiler.DynamicJavaFileManager;
import org.ifinalframework.java.compiler.StringJavaFileObject;

public class Compiler {
    private final JavaCompiler javaCompiler = ToolProvider.getSystemJavaCompiler();
    private final StandardJavaFileManager standardFileManager;
    private final List<String> options = new ArrayList<String>();
    private final DynamicClassLoader dynamicClassLoader;
    private final Collection<JavaFileObject> compilationUnits = new ArrayList<JavaFileObject>();
    private final List<Diagnostic<? extends JavaFileObject>> errors = new ArrayList<Diagnostic<? extends JavaFileObject>>();
    private final List<Diagnostic<? extends JavaFileObject>> warnings = new ArrayList<Diagnostic<? extends JavaFileObject>>();

    public Compiler(ClassLoader classLoader) {
        if (this.javaCompiler == null) {
            throw new IllegalStateException("Can not load JavaCompiler from javax.tools.ToolProvider#getSystemJavaCompiler(), please confirm the application running in JDK not JRE.");
        }
        this.standardFileManager = this.javaCompiler.getStandardFileManager(null, null, null);
        this.options.add("-Xlint:unchecked");
        this.dynamicClassLoader = new DynamicClassLoader(classLoader);
    }

    public void addSource(String className, String source) {
        this.addSource(new StringJavaFileObject(className, source));
    }

    public void addSource(JavaFileObject javaFileObject) {
        this.compilationUnits.add(javaFileObject);
    }

    public DynamicClassLoader compile() {
        this.errors.clear();
        this.warnings.clear();
        DynamicJavaFileManager fileManager = new DynamicJavaFileManager(this.standardFileManager, this.dynamicClassLoader);
        DiagnosticCollector collector = new DiagnosticCollector();
        JavaCompiler.CompilationTask task = this.javaCompiler.getTask(null, fileManager, collector, this.options, null, this.compilationUnits);
        try {
            boolean result22;
            if (!(this.compilationUnits.isEmpty() || (result22 = task.call().booleanValue()) && collector.getDiagnostics().isEmpty())) {
                block8: for (Diagnostic diagnostic : collector.getDiagnostics()) {
                    switch (diagnostic.getKind()) {
                        case NOTE: 
                        case MANDATORY_WARNING: 
                        case WARNING: {
                            this.warnings.add(diagnostic);
                            continue block8;
                        }
                    }
                    this.errors.add(diagnostic);
                }
                if (!this.errors.isEmpty()) {
                    throw new DynamicCompilerException("Compilation Error", this.errors);
                }
            }
            DynamicClassLoader result22 = this.dynamicClassLoader;
            return result22;
        }
        catch (Exception e) {
            throw new DynamicCompilerException(e, this.errors);
        }
        finally {
            this.compilationUnits.clear();
        }
    }

    public Map<String, Class<?>> build() throws ClassNotFoundException {
        DynamicClassLoader classLoader = this.compile();
        return classLoader.getClasses();
    }

    public Map<String, byte[]> buildByteCodes() {
        return this.compile().getByteCodes();
    }

    private List<String> diagnosticToString(List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        ArrayList<String> diagnosticMessages = new ArrayList<String>();
        for (Diagnostic<? extends JavaFileObject> diagnostic : diagnostics) {
            diagnosticMessages.add("line: " + diagnostic.getLineNumber() + ", message: " + diagnostic.getMessage(Locale.US));
        }
        return diagnosticMessages;
    }

    public List<String> getErrors() {
        return this.diagnosticToString(this.errors);
    }

    public List<String> getWarnings() {
        return this.diagnosticToString(this.warnings);
    }

    public ClassLoader getClassLoader() {
        return this.dynamicClassLoader;
    }
}

