/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.java.compiler;

import java.util.HashMap;
import java.util.Map;
import org.ifinalframework.java.compiler.BytesJavaFileObject;

public class DynamicClassLoader
extends ClassLoader {
    private final Map<String, BytesJavaFileObject> byteCodes = new HashMap<String, BytesJavaFileObject>();

    public DynamicClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    public void registerCompiledSource(BytesJavaFileObject byteCode) {
        this.byteCodes.put(byteCode.getClassName(), byteCode);
    }

    @Override
    protected Class<?> findClass(String name) throws ClassNotFoundException {
        BytesJavaFileObject byteCode = this.byteCodes.get(name);
        if (byteCode == null) {
            return super.findClass(name);
        }
        return super.defineClass(name, byteCode.getByteCode(), 0, byteCode.getByteCode().length);
    }

    public Map<String, Class<?>> getClasses() throws ClassNotFoundException {
        HashMap classes = new HashMap();
        for (BytesJavaFileObject byteCode : this.byteCodes.values()) {
            classes.put(byteCode.getClassName(), this.findClass(byteCode.getClassName()));
        }
        return classes;
    }

    public Map<String, byte[]> getByteCodes() {
        HashMap<String, byte[]> result = new HashMap<String, byte[]>(this.byteCodes.size());
        for (Map.Entry<String, BytesJavaFileObject> entry : this.byteCodes.entrySet()) {
            result.put(entry.getKey(), entry.getValue().getByteCode());
        }
        return result;
    }
}

